GrDateTimePicker = (function() {
  function GrDateTimePicker() {}

  GrDateTimePicker.prototype.initialize = function() {
    this.elem = null;
    this.dateTimeRanges = null;
    this.startDate = moment().startOf('day');
    return this.endDate = moment().add('days', 1).startOf('day');
  };
  
  GrDateTimePicker.prototype.L = function(str) {
    return str;
  }

  GrDateTimePicker.prototype.attach = function(elem, weekType, valueChanged) {
    var last24HrStr, lastMonthStr, lastWeekStr, lastYearStr, monthToDateStr, todayRange, todayStr, weekToDateStr, yearToDateStr, yesterdayStr;

    if (weekType === null) {
      weekType = 'isoWeek';
    }
    if (valueChanged === null) {
      valueChanged = null;
    }
    this.elem = elem;
    todayStr = this.L("Today");
    yesterdayStr = this.L("Yesterday");
    last24HrStr = this.L('Last 24hr');
    weekToDateStr = this.L('Week to date');
    lastWeekStr = this.L('Last week');
    monthToDateStr = this.L('Month to date');
    lastMonthStr = this.L('Last Month');
    yearToDateStr = this.L('Year to date');
    lastYearStr = this.L('Last year');
    this.dateTimeRanges = {};
    this.dateTimeRanges[todayStr] = [moment().startOf('day'), moment().add('days', 1).startOf('day')];
    this.dateTimeRanges[yesterdayStr] = [moment().subtract('days', 1).startOf('day'), moment().startOf('day')];
    this.dateTimeRanges[last24HrStr] = [moment().subtract('hours', 24), moment()];
    this.dateTimeRanges[weekToDateStr] = [moment().startOf(weekType), moment().add('days', 1).startOf('day')];
    this.dateTimeRanges[lastWeekStr] = [moment().subtract('weeks', 1).startOf(weekType), moment().startOf(weekType)];
    this.dateTimeRanges[monthToDateStr] = [moment().startOf('month'), moment().add('days', 1).startOf('day')];
    this.dateTimeRanges[lastMonthStr] = [moment().subtract('months', 1).startOf('month'), moment().startOf('month')];
    this.dateTimeRanges[yearToDateStr] = [moment().startOf('year'), moment().add('days', 1).startOf('day')];
    this.dateTimeRanges[lastYearStr] = [moment().subtract('years', 1).startOf('year'), moment().startOf('year')];
    todayRange = this.dateTimeRanges[todayStr];
    this.startDate = todayRange[0];
    this.endDate = todayRange[1];
    $(elem).daterangepicker({
      startDate: this.startDate,
      endDate: this.endDate,
      timePicker: true,
      timePicker12Hour: false,
      timePickerIncrement: 1,
      showDropdowns: true,
      format: 'MM/DD/YYYY HH:mm',
      ranges: this.dateTimeRanges
    }, valueChanged);
    $(elem).data('daterangepicker').hide();
    return;
  };

  GrDateTimePicker.prototype.rangeLabel = function(start, end) {
    var invertedRanges;

    invertedRanges = _.invert(this.dateTimeRanges);
    if (_.has(invertedRanges, [start, end])) {
      return invertedRanges[[start, end]];
    } else {
      return start.format('YYYY/MM/DD HH:mm') + ' - ' + end.format('YYYY/MM/DD HH:mm');
    }
  };

  GrDateTimePicker.prototype.update = function() {
    var picker;

    picker = $(this.elem).find('.datetime-range').data('daterangepicker');
    if (!picker) {
      return;
    }
    picker.setStartDate(this.startDate);
    return picker.setEndDate(this.endDate);
  };

  GrDateTimePicker.prototype.updateRange = function(start, end) {
    this.startDate = start;
    this.endDate = end;
    return $(this.elem).find(".rangeLabel").text(this.rangeLabel(start, end));
  };

  return GrDateTimePicker;

})();
