window.WidgetAdapter = function(settings) 
{
  var self = this;
  // currentSettings will store all user's original setting without any modification
  var currentSettings = settings;
  // data store's all CaculatedValue, for example data slot: WriteFloat.out,
  // but for action slot, we only care about the action's path, not it's
  // value, although action slot is kind of CalculatedValue(we need it to use
  // the builtin menu function to select action slot path), it should not be stored in data
  var data = {};

  self.render = function(containerElement) 
  {
    self.elem = containerElement;
    $(self.elem).addClass("cpt-widget");
    self.containerId = _.uniqueId('dashboard_elem');
    $(self.elem).attr("id", self.containerId);

    $(self.elem).on("widget.error", self.onWidgetError);
    $(self.elem).on("widget.ok", self.onWidgetOk);

    //GOTCHA: defer init() call to avoid containerElement's height not
    //initialized well. without this defer, widget will be always rendered in
    //one row height
    setTimeout(function() { 
      self.width = $(self.elem).width();
      self.height = $(self.elem).height();
      self.init(); 
    });
  };

  self.getHeight = function() { 
    var rows = parseInt(currentSettings.rows, 10);
    if (isNaN(rows))
      return 4;
    else
      return rows;
  };

  self.onSettingsChanged = function(newSettings) { 
    currentSettings = newSettings;

    //update data if there are setting values stored here
    for(var setting in newSettings) {
      if (!_.has(data, setting))
        continue;
      
      data[setting] = newSettings[setting];
    }

    $(self.elem).trigger("settingsChanged");
  };

  self.onCalculatedValueChanged = function(settingName, newValue) {
    if (newValue == "null")
      return;

    var oldVal = data[settingName];
    data[settingName] = newValue;
    if (oldVal !== newValue)
      self.stopLoader(newValue);
      self.update(settingName);
  };

  self.onDispose = this.cleanup;
  

  /////////////// CPT Data Interfaces /////////////
  this.hasWritePerm = function() {
    return window.perms['canWriteDataSource'] != undefined && window.perms['canWriteDataSource'];
  };
    
  this.hasData = function(dataName) {
    return _.has(data, dataName);
  };

  this.getDataPath= function(dataName) {
    if(!_.has(currentSettings, dataName))
      return null;

    if (this.isDataSourcePath(currentSettings[dataName]))
      return currentSettings[dataName];
    else
      return null;
  };

  this.readData = function(dataName) {
    if (!data)
      return null;

    if (self.hasData(dataName) && !_.isNaN(data[dataName]) && !(data[dataName] === null)) 
      return data[dataName];
    else if(_.has(currentSettings, dataName))
      return currentSettings[dataName];
    else
      return null;
  };
    
  this.invokeAction = function(actionPath, value, valueDataType, settings) {
    if (valueDataType == null) {
      valueDataType = "void";
      
      var type = this.slotDataType(actionPath);
      if (type)
        valueDataType = type;
    }

    if (!this.hasWritePerm()) {
      return this.logAndReturn("permission denied");
    }
    if (actionPath == null) {
      return this.logAndReturn("invalid actionPath: " + actionPath);
    }

    var dsName = null;
    if (this.isUserProp(actionPath))
    {
      actionPath = this.readData(actionPath);
      if (actionPath == null) {
        return this.logAndReturn("invalid actionPath: " + actionPath);
      }
    }
    else if (this.isDataSourcePath(actionPath)) {
      dsName = this.datasourceName(actionPath);
      actionPath = this.datasourcePath2Path(actionPath)
    }
    
    $(this.elem).trigger("widget.ok");
    if (valueDataType != "void" && _.isUndefined(value))
    {
      var self = this;
      this.getUserInputDlg(this.L("Action Parameter"), 
          this.L("Please set a value for action: ")+actionPath, 
          this.L("Parameter")+"("+valueDataType+"): ", valueDataType, 
          function(param) { 
            self.postRequest(dsName, actionPath, valueDataType, param, settings, true);
          }
      );
    }
    else {
      var paramVal = valueDataType == "void" ? null : value;
      return this.postRequest(dsName, actionPath, valueDataType, paramVal, settings, true);
    }
  };

  this.writeData = function(dataPath, dataValue, settings) {
    if (!this.hasWritePerm()) {
      return this.logAndReturn("permission denied");
    }

    if (dataPath == null)
      return this.logAndReturn("invalid dataPath: " + dataPath);

    if (this.isUserProp(dataPath))
    {
      if(_.has(currentSettings, dataPath))
        dataPath = currentSettings[dataPath];
    }

    if (!this.isDataSourcePath(dataPath))
      return this.logAndReturn("invalid datasource path: " + dataPath);

    var valueDataType = this.slotDataType(dataPath);
    if (!valueDataType || valueDataType == "void")
      return this.logAndReturn("invalid slot data type: " + valueDataType);

    var dsName = this.datasourceName(dataPath);
    dataPath = this.datasourcePath2Path(dataPath);

    if (dataPath == null) {
      return this.logAndReturn("invalid dataPath: " + dataPath);
    }
    
    $(this.elem).trigger("widget.ok");

    //show data update loading icon
    this.stopLoader();
    this.startLoader(dataValue, valueDataType);

    return this.postRequest(dsName, dataPath, valueDataType, dataValue, settings, false);
  };
    
  this.runSqlQuery = function(sql, dataHandler, responseFormat, settings) {
    // following codes are copied from graphic.js that is generated from
    // graphic.coffee, with just a few modification
    var params, _this = this;

    if (responseFormat == null) {
      responseFormat = "json";
    }
    if (settings == null) {
      settings = {};
    }
    sql = _.str.trim(sql);
    if (!(_.str.startsWith(sql.toLowerCase(), "select"))) {
      console.warn("only select sql statement(readonly) is permitted.");
      return;
    }
    params = {
      type: "GET",
      url: "../app/sql_query.php",
      data: {
        sql: sql,
        responseFormat: responseFormat
      },
      dataType: 'json',
      success: function(data) {
        var result;

        if (data.error) {
          return console.error("failed to run sql (" + sql + "), error: " + data.error.text);
        } else if (data.redirect != null) {
          window.location.href = data.redirect;
          return;
        } else {
          result = data.data;
          if (dataHandler != null) {
            dataHandler(result);
          }
          if (settings['success'] != null) {
            return settings['success']();
          }
        }
      }
    };
    if (settings['beforeSend']) {
      params['beforeSend'] = settings['beforeSend'];
    }
    if (settings['complete']) {
      params['complete'] = settings['complete'];
    }
    if (settings['error']) {
      params['error'] = settings['error'];
    }
    //GOTCHA: does not support to run sql query cross domain, only can run it
    //on current host
    return $.ajax(params);
  };
    
  this.readNote = function(path, dataHandler, settings) {
    // following codes are copied from graphic.js that is generated from
    // graphic.coffee, with just a few modification
    var params, _this = this;

    if (settings == null) {
      settings = {};
    }
    params = {
      type: "GET",
      url: "../app/note_controller.php",
      data: {
        path: path
      },
      dataType: 'json',
      success: function(data) {
        var content;

        if (data.error) {
          if (settings['error'] != null) {
            settings['error']();
          }
          return console.error("failed to get note (" + path + "), error: " + data.error.text);
        } else if (data.redirect != null) {
          window.location.href = data.redirect;
          return;
        } else {
          content = data.content;
          if (dataHandler != null) {
            dataHandler(content);
          }
          if (settings['success'] != null) {
            return settings['success']();
          }
        }
      }
    };
    if (settings['beforeSend']) {
      params['beforeSend'] = settings['beforeSend'];
    }
    if (settings['complete']) {
      params['complete'] = settings['complete'];
    }
    if (settings['error']) {
      params['error'] = settings['error'];
    }
    //GOTCHA: does not support to run sql query cross domain, only can run it
    //on current host
    return $.ajax(params);
  };
    
  this.writeNote = function(path, content, settings) {
    // following codes are copied from graphic.js that is generated from
    // graphic.coffee, with just a few modification
    var params,
      _this = this;

    if (settings == null) {
      settings = {};
    }
    if (!this.hasWritePerm()) {
      return "permission denied";
    }
    params = {
      type: "POST",
      url: "../app/note_controller.php",
      data: {
        path: path,
        content: content
      },
      dataType: 'json',
      success: function(data) {
        var resp;

        if (data.error) {
          if (settings['error'] != null) {
            settings['error']();
          }
          return console.error("failed to save note (" + path + "): " + data.error.text);
        } else if (data.redirect != null) {
          window.location.href = data.redirect;
          return;
        } else {
          resp = data.response;
          if (settings['success'] != null) {
            return settings['success']();
          }
        }
      }
    };
    if (settings['beforeSend']) {
      params['beforeSend'] = settings['beforeSend'];
    }
    if (settings['complete']) {
      params['complete'] = settings['complete'];
    }
    if (settings['error']) {
      params['error'] = settings['error'];
    }
    //GOTCHA: does not support to run sql query cross domain, only can run it
    //on current host
    return $.ajax(params);
  };

  /////////////// Public Helpers ////////////////////////
  this.startSpinner = function() 
  {
    freeboard.showLoadingIndicator(true);
  }

  this.stopSpinner = function() 
  {
    freeboard.showLoadingIndicator(false);
  }
  
  this.handleColorData = function(cr) 
  {
    var parts;
    
    if (!cr) {
      return "";
    }

    if (cr.startsWith('#')) {
      return cr;
    }
    parts = cr.split(",");
    if (parts.length === 4) {
      parts[3] = parts[3] / 255;
      return "rgba(" + (parts.join(",")) + ")";
    } else if (parts.length === 3) {
      return "rgb(" + (parts.join(",")) + ")";
    } else {
      return "";
    }
  }
  
  this.parseEnumData = function(dataName) {
    var choice_default_val, choices, _ref59;

    choices = (_ref59 = this.readData(dataName)) != null ? _ref59.split(',') : void 0;
    if (!choices) {
      return [];
    }
    choice_default_val = 0;
    return _.map(choices, function(c) {
      var obj;

      obj = _.object(['label', 'value'], c.split(':'));
      obj.value = parseFloat(obj.value);
      if (isNaN(obj.value)) {
        obj.value = choice_default_val;
      } else {
        choice_default_val = obj.value;
      }
      ++choice_default_val;
      return obj;
    });
  };

  this.slotDataType = function(datasourcePath)
  {
    if (this.isUserProp(datasourcePath)) 
    {
      if(_.has(currentSettings, datasourcePath))
        datasourcePath = currentSettings[datasourcePath];
    }

    var slotInfo = this.datasourcePath2SlotInfo(datasourcePath);
    return slotInfo['type'];
  }

  this.isAction = function(datasourcePath)
  {
    var slotInfo = this.datasourcePath2SlotInfo(datasourcePath);
    return slotInfo['slotType'] == "action";
  }
  
  this.L = function(str)
  {
    return str;
  }

  /////////////// Private Helpers ////////////////////////
  this.logAndReturn = function(msg)
  {
    console.log(msg);
    return msg;
  };

  this.isUserProp = function(propName)
  {
    return _.str.startsWith(propName, '@')
  }
  
  this.isDataSourcePath = function(propName)
  {
    return _.str.startsWith(propName, 'datasources[')
  }
  this.datasourcePath2Path = function(datasourcePath)
  {
    return _.str.rtrim(_.last(datasourcePath.split('"]["'), 2).join("."), '"]')
  }
  this.datasourceName = function(datasourcePath)
  {
    if (!this.isDataSourcePath(datasourcePath))
      return null;

    var parts = datasourcePath.split('"');
    if (parts.length > 1)
      return parts[1];
    else
      return null;
  }
  
  this.datasourcePath2SlotInfo = function(datasourcePath)
  {
    var defaultVal = {};

    if (_.isUndefined(window.g_compTypeData))
      return defaultVal;

    if (!this.isDataSourcePath(datasourcePath))
      return defaultVal;

    var dsName = this.datasourceName(datasourcePath);
    var slotPath = this.datasourcePath2Path(datasourcePath);
    var parts = slotPath.split(".");
    if (parts.length != 2)
      return defaultVal;
    
    var compPath = parts[0];
    var slotName = parts[1];
    
    try {
      return window.g_compTypeData[dsName][compPath][slotName];
    } catch(e) {
      return defaultVal;
    }
  }
  
  this.getUserInputDlg = function(title, desc, label, dataType, onInputCompleted) 
  {
    var dataModel = {
      input: ko.observable(''),
      bools: ['false', 'true', 'null'],
      error_msg: ko.observable('')
    }
    if (dataType == 'bool') {
      var template = _.template("<div><div style='font-size: 17px;'><p><%= desc %></p></div><div style='color:red; margin-top:5px; margin-bottom:5px;' data-bind='html: error_msg'></div><div><label for='user_input'><%= label %></label><select id='user_input' data-bind='value: input, options: bools'></select></div></div>");
    } else {
      var template = _.template("<div><div style='font-size: 17px;'><p><%= desc %></p></div><div style='color:red; margin-top:5px; margin-bottom:5px;' data-bind='html: error_msg'></div><div><label for='user_input'><%= label %></label><input type='text' id='user_input' data-bind='value: input' autofocus></div></div>");
    }
    var dom = $(template({desc:desc, label:label}));
    ko.applyBindings(dataModel, dom[0]);
    freeboard.showDialog(dom, title, L("Ok"), L("Cancel"), function() {
      dataModel.error_msg('');
      var param = dataModel.input();
      if (dataType == "int") {
        if (!/^\d+$/.test(param)) {
          dataModel.error_msg("invalid integer value");
          return true;
        }
      } else if (dataType == "float" || dataType == "double") {
        if (!/^\d+(\.\d*)?$/.test(param)) {
          dataModel.error_msg("invalid float value");
          return true;
        }
      } else if (dataType == "bool") {
        //if (param == 'false')
        //  param = 0;
        //else if (param == 'true')
        //  param = 1;
        //else if (param == 'null')
        //  param = 2;
      }

      onInputCompleted(param);
      return false;
    });
  }

  this.requestBaseUrl = function(dsName) {
    if (!dsName)
      return "";

    var dsSettings = freeboard.getDatasourceSettings(dsName);
    if (!dsSettings)
      return "";
    var protocol = dsSettings.useHTTPS ? "https" : "http";
    var host = (!dsSettings.controllerHost || dsSettings.controllerHost.length === 0) ? window.location.host : dsSettings.controllerHost;
    return protocol + "://" + host;
  }

  this.postRequest = function(dsName, dataPath, dataType, value, settings, isAction) 
  {
    if (settings == null) {
      settings = {};
    }

    var postData = {
      path: '/app/objects' + dataPath,
      slotType: (isAction ? 'action' : 'property'),
      type: dataType,
      value: value
    };

    var url = this.requestBaseUrl(dsName);
    url = url + "/sdcard/cpt/app/data_api.php";
    var params = {
      type: "POST",
      url: url,
      data: postData,
      dataType: 'json',
      xhrFields: { withCredentials: true },
      headers: {'X-Requested-With': 'XMLHttpRequest'},
      success: function(data) {
        if (data.error) {
          console.error("failed to send request: " + data.error.text);
        }
        else {
          var resp = data.response;
          if (resp != null && resp.resultCode != 0 ) {
            console.error("failed to send request: " + dataPath);
          }
          else {
            if(settings['success'] != null) {
              return settings['success']();
            }
          }
        }
      }
    }

    if (settings['beforeSend']) {
      params['beforeSend'] = settings['beforeSend'];
    }
    if (settings['complete']) {
      params['complete'] = settings['complete'];
    }
    if (settings['error']) {
      params['error'] = settings['error'];
    }

    return $.ajax(params);
  }
  
  this.startLoader = function(value, dataType) 
  {
    var timerId = setTimeout(_.bind(this.stopLoader, this), 10000);

    var loader = $("<div class='loader' data-expected_value='" + value + "' data-data_type='"+dataType+"' data-timerid='" + timerId + "'></div>");
    loader.appendTo($(self.elem));
  }
  
  this.stopLoader = function(newValue)
  {
    var loader = $(self.elem).find(".loader");
    if (loader.length == 0)
      return;
    
    var expectedValue = loader.data('expected_value');
    var dataType = loader.data('data_type');
    var timerId = Number.parseInt(loader.data('timerid'));
    
    if (_.isNull(newValue) || _.isUndefined(newValue)) {
      console.warn("wait for data update times out, stop loader."); 
      loader.remove();
      if (!Number.isNaN(timerId))
        clearTimeout(timerId);
    }
    else {
      var isEqual = false;
      if (dataType == "float" || dataType == "double")
        isEqual = Number.parseFloat(expectedValue) == Number.parseFloat(newValue);
      else if (dataType == "int" || dataType == "byte" || dataType == "short" || dataType == "long")
        isEqual = Number.parseInt(expectedValue) == Number.parseInt(newValue);
      else
        isEqual = expectedValue == newValue;
      
      if (isEqual) {
        loader.remove();
        if (!Number.isNaN(timerId))
          clearTimeout(timerId);
      } 
      else
        console.debug("value doesn't match");
    }
  }

  this.onWidgetError = function(e, errMsg)
  {
    var jqElem = $(self.elem);
    // jqElem.css("background-color", "red");
    var signElem = jqElem.find(".error-sign");
    if (signElem.size() == 0) {
      signElem = $("<div class='error-sign tooltip'><span class='tooltiptext'>" + errMsg + "</span></div>").click(function() {
        signElem.find(".tooltiptext").toggle();
      });
      signElem.appendTo(jqElem);
    }
    else {
      // just update tooltiptext
      signElem.find(".tooltiptext").text(errMsg);
    }
  }

  this.onWidgetOk = function() 
  {
    // $(self.elem).css("background-color", "");
    $(self.elem).find(".error-sign").remove();
  }
  
  this.isDashboard = function() { return true; }

};
