<?php
// vim: ts=2 sw=2

include_once "db.php";
include_once "base_controller.php";

class DashboardController extends BaseController {
  protected function signinRequired() {
    return true;
  }

  public function doAjaxGet() {
    $response = array();
    $action = $_GET['action'];
    if ($action == 'list')
      $this->listDashboard();
    if ($action == 'load')
      $this->loadDashboard();
    else
      $this->renderAjaxError($response, sprintf(L("%s is not supported"), $action);
  }
  
  protected function listDashboard() {
    //only enable dashboard for FG+
    if (!FeatureControl::instance()->isEnabled("Dashboard"))
      die('{}');

    $dashboards = Dashboard::dashboardList();
    
    $response = array();
    foreach($dashboards as $dashboard) {
      $response[] = map2json($dashboard);
    }
    die('{"response": [' . implode(",", $response) . ']}');
  }
  
  public function doAjaxPost() {
    $response = array();
    $action = $_POST['action'];
    if ($action == 'save')
      $this->doSave();
    else if ($action == 'rename')
      $this->doRename();
    else if ($action == 'delete')
      $this->doDelete();
    else if ($action == 'layout')
      $this->doLayout();
    else
      $this->renderAjaxError($response, sprintf(L('%s is not supported'), $action));
  }
  
  protected function doSave() {
    $response = array();
    if (!isset($_POST['name']))
      $this->renderAjaxError($response, sprintf(L("missing '%s' parameter"), 'name'));

    $board = new Dashboard();
    if (isset($_POST['id'])) { // update
      $id = $_POST['id'];
      if (!$board->findById($id))
        $this->renderAjaxError($response, L("can not find dashboard for id: ") . $id);
      
      $board->saveDashboard($_POST['name'], $_POST['content']);
      $response['id'] = $id;
    } else { // create
      if (!isset($_POST['name']) || !isset($_POST['content']))
        $this->renderAjaxError($response, sprintf(L("missing parameters: both '%s' and '%s' are required."), 'name', 'content'));
      $id = $board->createDashboard($_POST['name'], $_POST['content']);
      if ($id)
        $response['id'] = $id;
      else
        $this->renderAjaxError($response, L("failed to create dashboard"));
    }
    die('{"response": ' . map2json($response). '}');
  }
  
  protected function loadDashboard() {
    $response = array();
    $id = $_GET['id'];
    $board = new Dashboard();
    if ($board->findById($id)) {
      die('{"response": ' . $board->attr("content") . '}');
    } else {
      $this->renderAjaxError($response, L("can not find dashboard for id: ") . $id);
    }
  }
  
  protected function doRename() {
    $response = array();
    if (!isset($_POST['new_name']) || !isset($_POST['id']))
      $this->renderAjaxError($response, "missing parameters");

    $id = $_POST['id'];
    $new_name = $_POST['new_name'];

    $board = new Dashboard(); 
    if ($board->renameDashboard($id, $new_name))
      $this->renderAjaxSuccess($response);
    else
    {
      $error = sprintf(L("failed to rename dashboard(#%s) to %s"), $id, $new_name);
      $this->renderAjaxError($response, $error);
    }
  }
  
  protected function doDelete() {
    $response = array();
    if (!isset($_POST['id_list']))
      $this->renderAjaxError($response, L("invalid parameter"));
    
    $id_list = explode(",", $_POST['id_list']);
    if (Dashboard::deleteDashboard($id_list))
      $this->renderAjaxSuccess($response); 
    else
      $this->renderAjaxError($response, L("failed to delete dashboards: ") . $_POST['id_list']);
  }

  // HERE
  protected function doLayout() {
    $response = array();
    if (!isset($_POST['id']) || !isset($_POST['parent_id']) || !isset($_POST['sibling_ids']))
      $this->renderAjaxError($response, L("invalid parameter"));

    $id = $_POST['id'];
    $parent_id = $_POST['parent_id'];
    $sibling_ids = explode(',', $_POST['sibling_ids']);
    
    if (Dashboard::updateLayout($id, $parent_id, $sibling_ids))
      $this->renderAjaxSuccess($response); 
    else
    {
      $error = sprintf(L("failed to update layout for dashboard(#%s)"), $id);
      $this->renderAjaxError($response, $error);
    }
  }
  
  protected function dashboardPath($full_path) {
    $basePath = $this->buildPath() . "/";
    if (!startsWith($full_path, $basePath)) {
      error_log("seems a wrong file path: " . $full_path);
      return $full_path;
    } else {
      return substr($full_path, strlen($basePath));
    }
  }
  
  protected function buildPath($name=NULL) {
    if ($name == NULL)
      return build_file_path(cptBaseDir(), "app", "dashboards");
    else
      return build_file_path(cptBaseDir(), "app", "dashboards", $name);
  }
  
}

$controller = new DashboardController();
$controller->run();

?>
