<?php
//vim: ts=2 sw=2

include_once "db.php";
include_once "base_controller.php";

class UpgradeFirmwareController extends BaseController {
  protected function signinRequired() {
    return true;
  }

  protected function adminRequired() {
    return true;
  }
  
  protected function genResponse() {
    $file = $_FILES['firmwareFile'];
    $tempPath = $file['tmp_name'];
    $name = $file['name'];
    
    //check if firmware file is too small
    $fileSize = filesize($tempPath);
    if ($fileSize < 1*1024*1024) {
        echo "The uploaded file size is invalid.";
        return;
    }
    $fwPath = firmwareUpgradePath();
    if (!is_null($fwPath)) {
        //check if enough space left 
        $freeSpace = disk_free_space($fwPath);
        if ($freeSpace < $fileSize+1*1024*1024) {
            echo "No enough space left.";
            return;
        }

        $dstPath = build_file_path($fwPath, basename($name));
        move_uploaded_file($tempPath, $dstPath);
        sync();
        echo "SUCCESS: File '$name' is uploaded sucessfully.";
    }
    else {
        echo "This platform is not supported.";
    }
  }
  
  protected function doAjaxPost() {
    $this->genResponse();
  }

  protected function doPost() {
    echo '<textarea>';
    $this->genResponse();
    echo '</textarea>';
  }
}

$controller = new UpgradeFirmwareController();
$controller->run();

?>
