<?php
//vim: ts=2 sw=2

include_once "utils.php";

class INIFile {
    protected $configs = NULL;
    protected $ini_file_name = "";
    
    public function load($file_name) {
      $this->ini_file_name = $file_name;
      if (!file_exists($this->ini_file_name))
      {
        //error_log("can not find ini file:" . $this->ini_file_name);
        return false;
      }

      $this->configs = parse_ini_file($this->ini_file_name, true);
      if (!$this->configs)
      {
        error_log("can not parse ini file:" . $this->ini_file_name);
        return false;
      }
      return true;
    }

    protected function put_ini_file($file, $array, $i = 0) {
        $str="";
        foreach ($array as $k => $v){
            if (is_array($v)){
                $str.=str_repeat(" ",$i*2)."[$k]".PHP_EOL;
                $str.=$this->put_ini_file("",$v, $i+1);
            }else
                $str.=str_repeat(" ",$i*2)."$k=$v".PHP_EOL; 
        }
        if($file)
            return file_force_contents($file, $str);
        else
            return $str;
    }

    public function save() {
        if (!$this->configs)
            return;
        $this->put_ini_file($this->ini_file_name, $this->configs);
    }
    
    public function value($section, $key, $defaultVal) {
        if (!$this->configs)
            return $defaultVal;
        
        if (is_null($section)) {
          if (!in_array($key, array_keys($this->configs)))
              return $defaultVal;
          return $this->configs[$key];
        } else {
          if (!in_array($section, array_keys($this->configs)))
              return $defaultVal;
          
          if (!in_array($key, array_keys($this->configs[$section])))
              return $defaultVal;

          return $this->configs[$section][$key];
        }
    }
    
    public function setValue($section, $key, $value) {
        if (!$this->configs)
            $this->configs = array();
        
        if (is_null($section)) {
          $this->configs[$key] = $value;
        } else {
          if (!in_array($section, array_keys($this->configs)))
              $this->configs[$section] = array();

          $this->configs[$section][$key] = $value;
        }
    }
}

?>
