<?php
//vim: ts=2 sw=2

// include_once "../app/config.php";
// include_once "../app/utils.php";

function endsWith($haystack, $needle) {
  return $needle === "" || substr($haystack, -strlen($needle)) === $needle;
}

function sync() {
    // shell_exec("sync");
    // shell_exec("echo 3 > /proc/sys/vm/drop_caches");
    // return;
    
    $output = array();
    $return_val = 0;
    exec("sync", $output, $return_val);
    error_log("sync output : " . implode("\n", $output) . " return: " . $return_val);

    unset($output);

    $return_val = 0;
    exec("echo 3 > /proc/sys/vm/drop_caches", $output, $return_val);
    error_log("drop caches output : " . implode("\n", $output) . " return: " . $return_val);
}

class DiagnoseController {
  public function run() {
    sync();
    $resp = $this->runDiagnoseScripts();
    $this->cleanup();
    sync();

    // $docRootPath = rtrim($_SERVER['DOCUMENT_ROOT'], '/');
    die($resp);
  }
  
  protected function runDiagnoseScripts() {
    $content = array();
    $content[] = $this->test_sdcard_existence();
    return implode('\n', $content); 
  }
  
  protected function test_sdcard_existence() {
    $filePath = realpath("/sdcard/No SD Card");
    if (file_exists($filePath))
      return "sdcard not available";
    else
      return "sdcard card is available";
  }

  protected function cleanup() {
    $docRootPath = rtrim($_SERVER['DOCUMENT_ROOT'], '/');
    $diagnosePath = $docRootPath . '/' . 'diagnose';

    $itDir = new RecursiveDirectoryIterator($diagnosePath, RecursiveDirectoryIterator::SKIP_DOTS);
    $it = new RecursiveIteratorIterator($itDir, RecursiveIteratorIterator::CHILD_FIRST, RecursiveIteratorIterator::CATCH_GET_CHILD);
    foreach($it as $path => $dir)
    {
      if ($dir->isDir())
        rmdir($path);
      else
        unlink($path);
    }
    rmdir($diagnosePath);
  }
}

$controller = new DiagnoseController();
$controller->run();
    
?>
