<?php
//vim: ts=2 sw=2

include_once "utils.php";

class BaseController {

  public $flash = NULL;

  function __construct() {}

  private function isHttps() {
    return (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off'
    || $_SERVER['SERVER_PORT'] == 443);
  }

  protected function makeUrl($url) {
    $pageURL = 'http';
    if ($this->isHttps()) {$pageURL .= "s";}
    $pageURL .= "://" . $_SERVER["HTTP_HOST"];
    if ($_SERVER["SERVER_PORT"] != "80") {
      $port_str = ":".$_SERVER["SERVER_PORT"];
      if (!endsWith($pageURL, $port_str))
        $pageURL .=  $port_str;
    }
    if (startsWith($url, '/'))
      $pageURL .= $url;
    else
      $pageURL .= $this->cptBaseUrl() . '/' . $url;
    return $pageURL;
  }

  protected function cptBaseUrl() {
    $rootPath = $_SERVER['DOCUMENT_ROOT'];
    $curPath = substr(__FILE__, strlen($rootPath));
    $parts = explode(DIRECTORY_SEPARATOR, $curPath);
    array_pop($parts);
    array_pop($parts);

    //NOTE: since we are dealing with URL, so only '/' is valid, even on 
    //windows platform. no need to use DIRECTORY_SEPARATOR 
    $result = implode('/', $parts);
    if (!startsWith($result, '/'))
        $result = '/' . $result;
    return $result;
  }

  private function isAjax() {
    return (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest');
  }

  protected function signinRequired() {
    return false;
  }

  protected function adminRequired() {
    return false;
  }

  protected function isSignedin() {
    return isset($_SESSION['user_id']);
  }

  protected function redirect($url, $permanent = false) {
    if ($this->isAjax())
    {
        $url = addcslashes($url,"\\\"\n\r");
        die('{"redirect": "' . $url . '"}');
    }
    else
    {
        header('Location: ' . $url, true, $permanent ? 301 : 302);
        die();
    }
  }

  public function run() {
    session_start(Array('name' => 'CPTSESSID'));

    if ($this->signinRequired() && !$this->isSignedin()) {
      if (!$this->isAjax())
        $_SESSION['url_required'] = $_SERVER[REQUEST_URI];
      $this->redirect($this->makeUrl('app/signin.php'));
    }

    if ($this->isAjax()) {
      $this->ajaxRun();
    } else {
      $this->normalRun();
    }
  }

  public function flash() {
    if (!is_null($this->flash))
      return $this->flash;

    if(isset($_SESSION['flash'])) {
      $this->flash = $_SESSION['flash'];
      unset($_SESSION['flash']);
      return $this->flash;
    } else
      return NULL;
  }

  protected function normalRun() {
    $method = $_SERVER['REQUEST_METHOD'];
    if ($method == "POST") {
      $this->doPost();
    } else if ($method == "GET") {
      $this->doGet();
    } else {
        error_log("request method '" . $method . "' is not supported");
    }
  }

  protected function ajaxRun() {
    $response = array();
    $method = $_SERVER['REQUEST_METHOD'];
    if ($method == "POST") {
      $this->doAjaxPost();
    } else if ($method == "GET") {
      $this->doAjaxGet();
    } else {
      $response['error'] = array('text' => "$method is not supported");
      echo <<<EOS
{"error": {"text": "{$response['error']['text']}"}}
EOS;
    }
  }

  protected function renderAjaxError($response, $error) {
    $response['error'] = array('text' => addcslashes($error, "\\\"\n\r"));
    die(<<<EOS
{"error": {"text": "{$response['error']['text']}"}}
EOS
    );
  }

  protected function renderAjaxSuccess($response, $escapeStr=true) {
    $json = array();
    foreach($response as $k => $v) {
      if ($escapeStr && is_string($v))
          $v = addcslashes($v, "\\\"\n\r");
          // $v = addslashes($v); // should not escape single quote for json string
      $json[] = "\"$k\": \"$v\"";
    }
    die('{' . implode(',', $json) . '}');
  }

  protected function renderErrorResponse($error) {
    if ($this->isAjax()) {
      $response = array();
      $this->renderAjaxError($response, $error);
    } else {
      die($error);
    }
  }

  protected function escapeJsonChars($val) {
    return addcslashes($val, "\\\"\n\r");
  }

  protected function map2json($mapData) {
    $json = array();
    foreach($mapData as $k => $v) {
      if (is_string($v))
          $v = addcslashes($v,"\\\"\n\r");
      if (is_string($k))
          $k = addcslashes($k,"\\\"\n\r");
      $json[] = "\"$k\": \"$v\"";
    }
    return '{' . implode(',', $json) . '}';
  }

  protected function doGet() { }
  protected function doPost() { }

  protected function doAjaxGet() { }
  protected function doAjaxPost() { }
}

?>
