<?php
//vim: ts=2 sw=2

class PreDeploymentController {
  public function run() {
    $path = dirname(__FILE__);
    $freeSpace = disk_free_space($path);
    $sdcardExistence = ($this->does_sdcard_exist()) ? 'true' : 'false';
        
    if (isset($_GET['force_update'])) {
        if ($_GET['force_update'] == '1' || $_GET['force_update'] == 't')
            $this->handle_force_update();
    }

    //NOTE: there maybe int overflow issue when we use a large sdcard than 8G in future
    die(sprintf('{"disk": %s, "sdcardExistence": %s}', $freeSpace, $sdcardExistence));
  }

  protected function does_sdcard_exist() {
    $filePath = realpath("/sdcard/No SD Card");
    if (file_exists($filePath))
      return false;
    else
      return true;
  }
  
  protected function handle_force_update() {
    $this->del_dashboard_cpt_widgets();      
  }

  protected function del_dashboard_cpt_widgets() {
    $basePath = $this->parentPath(2);
    $widgetPath = $this->build_file_path($basePath, "dashboard/plugins/cpt/widgets");

    exec('rm -rf ' . $widgetPath . '/*');
  }

  protected function parentPath($level) {
    $curPath = __FILE__;
    $parts = explode(DIRECTORY_SEPARATOR, $curPath);
    for($i=0; $i<$level; ++$i)
      array_pop($parts);
    return implode(DIRECTORY_SEPARATOR, $parts);
  }

  protected function build_file_path() {
    return join(DIRECTORY_SEPARATOR, func_get_args());
  }
}

$controller = new PreDeploymentController();
$controller->run();
    
?>
