// Generated by CoffeeScript 1.6.2
(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  jQuery(function() {
    var AdapterWidget, ScriptLoaderSingleton, _ref;

    ScriptLoaderSingleton = (function() {
      var ScriptLoader, instance;

      function ScriptLoaderSingleton() {}

      instance = null;

      ScriptLoaderSingleton.instance = function() {
        return instance != null ? instance : instance = new ScriptLoader;
      };

      ScriptLoader = (function() {
        function ScriptLoader() {
          this.scriptFailed = __bind(this.scriptFailed, this);
          this.scriptLoaded = __bind(this.scriptLoaded, this);
        }

        ScriptLoader.prototype.load = function(scriptUrl, done, failed) {
          var dataType, stateData, _ref,
            _this = this;

          console.debug("start to load " + scriptUrl);
          if ((_ref = this.loadingStatus) == null) {
            this.loadingStatus = {};
          }
          stateData = this.loadingStatus[scriptUrl];
          if (typeof stateData === 'undefined') {
            this.loadingStatus[scriptUrl] = {
              state: 'loading',
              done: [],
              failed: []
            };
            dataType = _.str.endsWith(scriptUrl, ".js") && "script" || "text";
            $.ajax({
              url: scriptUrl,
              dataType: dataType,
              cache: true,
              success: function(data, status, xhr) {
                if (!_.str.endsWith(scriptUrl, ".css")) {
                  return;
                }
                return $('<style type="text/css"></style>').html(data).appendTo("head");
              }
            }).done(function() {
              return _this.scriptLoaded(scriptUrl);
            }).fail(function() {
              return _this.scriptFailed(scriptUrl);
            });
            if (done) {
              this.loadingStatus[scriptUrl].done.push(done);
            }
            if (failed) {
              return this.loadingStatus[scriptUrl].failed.push(failed);
            }
          } else if (stateData.state === 'loaded') {
            if (done) {
              return done(scriptUrl);
            }
          } else if (stateData.state === 'failed') {
            if (failed) {
              return failed(scriptUrl);
            }
          } else if (stateData.state === 'loading') {
            if (done) {
              stateData.done.push(done);
            }
            if (failed) {
              stateData.failed.push(failed);
            }
            return this.loadingStatus[scriptUrl] = stateData;
          }
        };

        ScriptLoader.prototype.scriptLoaded = function(scriptUrl) {
          var done, stateData, _i, _len, _ref;

          stateData = this.loadingStatus[scriptUrl];
          if (typeof stateData === 'undefined') {
            console.error("can not find loading status data for " + scriptUrl);
            return;
          }
          stateData.state = 'loaded';
          _ref = stateData.done;
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            done = _ref[_i];
            done(scriptUrl);
          }
          stateData.done = [];
          stateData.failed = [];
          return this.loadingStatus[scriptUrl] = stateData;
        };

        ScriptLoader.prototype.scriptFailed = function(scriptUrl) {
          var failed, stateData, _i, _len, _ref;

          stateData = this.loadingStatus[scriptUrl];
          if (typeof stateData === 'undefined') {
            console.error("can not find loading status data for " + scriptUrl);
            return;
          }
          stateData.state = 'failed';
          _ref = stateData.failed;
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            failed = _ref[_i];
            failed(scriptUrl);
          }
          stateData.done = [];
          stateData.failed = [];
          return this.loadingStatus[scriptUrl] = stateData;
        };

        return ScriptLoader;

      })();

      return ScriptLoaderSingleton;

    }).call(this);
    AdapterWidget = (function(_super) {
      __extends(AdapterWidget, _super);

      function AdapterWidget() {
        this.onDataChanged = __bind(this.onDataChanged, this);
        this.loadFailed = __bind(this.loadFailed, this);
        this.loadScripts = __bind(this.loadScripts, this);        _ref = AdapterWidget.__super__.constructor.apply(this, arguments);
        return _ref;
      }

      AdapterWidget.prototype.el = 'div#grWidget';

      AdapterWidget.prototype.initialize = function() {
        this.proxyObj = new ProxyObjectData;
        this.widgetName = "test";
        this.requiredScripts = [];
        if (this.proxyObj.hasOwnProperty("requiredScripts")) {
          this.requiredScripts = _.chain([this.proxyObj['requiredScripts']()]).flatten().compact().value();
        }
        return this.render();
      };

      AdapterWidget.prototype.render = function() {
        var widgetHeight, widgetWidth, _ref1, _ref2, _ref3, _ref4;

        widgetWidth = (_ref1 = (_ref2 = window.manifestObj) != null ? _ref2.width : void 0) != null ? _ref1 : 400;
        widgetHeight = (_ref3 = (_ref4 = window.manifestObj) != null ? _ref4.height : void 0) != null ? _ref3 : 800;
        this.$el.width(widgetWidth);
        this.$el.height(widgetHeight);
        this.$el.css("overflow", "visible");
        this.$el.css("margin", "20px auto");
        this.proxyObj['width'] = widgetWidth;
        this.proxyObj['height'] = widgetHeight;
        this.proxyObj['containerId'] = this.widgetName + '_container';
        this.proxyObj['elem'] = $("<div id='" + this.proxyObj['containerId'] + "' style='width:" + widgetWidth + "px; height:" + widgetHeight + "px; margin: auto'></div>").appendTo(this.$el);
        this.loadScripts();
        return this;
      };

      AdapterWidget.prototype.init = function() {
        var err;

        try {
          if (this.proxyObj.hasOwnProperty("init")) {
            this.proxyObj['init']();
          }
        } catch (_error) {
          err = _error;
          console.warn("failed to execute 'init' method: " + err.message);
        }
        return this.proxyObj._loaded = true;
      };

      AdapterWidget.prototype.loadScripts = function() {
        var scriptUrl;

        if (this.requiredScripts.length === 0) {
          return this.init();
        } else {
          scriptUrl = this.requiredScripts.shift();
          return ScriptLoaderSingleton.instance().load(scriptUrl, this.loadScripts, this.loadFailed);
        }
      };

      AdapterWidget.prototype.loadFailed = function(scriptUrl) {
        return console.warn("failed to load required script: " + scriptUrl);
      };

      AdapterWidget.prototype.onDataChanged = function(model, value, options) {
        var err, name;

        name = model.get('name');
        this.proxyObj.datas[name] = value;
        if (!this.proxyObj._loaded) {
          return;
        }
        try {
          if (this.proxyObj.hasOwnProperty("update")) {
            return this.proxyObj['update'](name);
          }
        } catch (_error) {
          err = _error;
          return console.warn("failed to execute 'update' method: " + err.message);
        }
      };

      return AdapterWidget;

    })(Backbone.View);
    return window.grWidget = new AdapterWidget;
  });

}).call(this);
