$(function() {

  //define components 
  var serviceControlComp = { //{{{1
    template: '#service-control-template',
    data: function() {
      return {
        service_list: [],

        spinner: null,
      };
    },
    mounted: function() {
      this.updateStatus();
    },
    methods: {
      getSpinner: function() {
        if (!this.spinner)
          this.spinner = new Spinner();
        return this.spinner;
      },

      updateStatus: function() {
        var self = this;
        $.ajax({
          url: 'service_control.php',
          type: 'GET', 
          dataType: 'json',
          beforeSend: function() {
            self.getSpinner().spin(self.$el);
          },
          success: function(resp) {
            if (resp.redirect)
              redirect(resp.redirect);

            self.service_list.splice(0)
            if (_.isArray(resp.services)) {
              for(let i=0; i<resp.services.length; ++i) 
                self.service_list.push(resp.services[i])
            } else {
              //TODO: display error message 
              console.warn("error response:");
              console.warn(resp);
            }
          },
          error: function(data, status) {
            console.warn("get error");
            console.warn(data);
          },
          complete: function() {
            self.getSpinner().stop();
            _.delay(_.bind(self.updateStatus, self), 5000);
          }
        });
      },

      isServiceControllable: function(service) {
        if (service.name != 'http' && service.name != 'https') 
          return true;

        return _.any(this.service_list, function(s) {
          if (service.name == s.name) return false;
          return (s.name == 'http' || s.name == 'https') && s.enabled;
        });
      },
      
      enableService: function(name) {
        this.controlService(name, "enable");
      },
      disableService: function(name) {
        if (name == "ftp")
          alert("The FTP service will be shutdown after all FTP client has been closed. Please make sure you have closed all FTP client(FileZilla etc) and CPT Tools.");
        this.controlService(name, "disable");
      },

      controlService: function(name, action) {
        var self = this;
        $.ajax({
          url: 'service_control.php',
          type: 'POST', 
          dataType: 'json',
          data: { name: name, action: action },
          beforeSend: function() {
            self.getSpinner().spin(self.$el);
          },
          success: function(resp) {
            if (resp.redirect)
              redirect(resp.redirect);
          },
          error: function(data, status) {
            console.warn("get error");
            console.warn(data);
          },
          complete: function() {
            self.getSpinner().stop();
          }
        });
      },
    },
  }; //}}}1

  //create&init root object
  var app = new Vue({ //{{{1
    el: '#service_control_content',
    data: {
    },
    methods: {
    },
    components: {
      // 'alert': alertComp,
      'service-control': serviceControlComp
    }
  }); //}}}1

});

// vim: foldmethod=marker
