<?php
//vim: ts=2 sw=2

set_include_path(get_include_path() . PATH_SEPARATOR . '../../app');
include_once "base_controller.php";

class FileUploadController extends BaseController {
  protected function signinRequired() {
    return true;
  }

  protected function adminRequired() {
    return true;
  }
  protected function platformControl() {
    return array('white_list' => ['FS']);
  }

  protected function dstFileDir() {
    if (!file_exists("/etc/nginx"))
      return null;

    if (!file_exists("/etc/nginx/certs/uploaded")) {
      mkdir("/etc/nginx/certs/uploaded", 0700, true);
    }
    return "/etc/nginx/certs/uploaded";
  }

  protected function afterFileUploaded() {
  //   `( sleep 1 && (/etc/init.d/S50nginx restart >/dev/null 2>&1 && echo SUCCESS) || (cp /etc/nginx/fs_server.pem.orig /etc/nginx/fs_server.pem && /etc/init.d/S50nginx restart >/dev/null 2>&1 && echo FAILURE) ) &`;
  //
  //   // if ($result != 'SUCCESS')
  //   //   error_log("imported HTTPS certificate is invalid, rolled back to original certificate.");
  }

  protected function genResponse() {
    $response = array();
    $file = null;
    $dst_fname = null;
    if (isset($_FILES['cert'])) {
      $file = $_FILES['cert'];
      $dst_fname = 'cert';
    } else if (isset($_FILES['key'])) {
      $file = $_FILES['key'];
      $dst_fname = 'key';
    }

    if (is_null($file)) {
      if ($this->isAjax())
        $this->renderAjaxError($response, "no 'cert' or 'key' parameter found.");
      else
        echo "no 'cert' or 'key' parameter found.";
      return;
    }

    $tempPath = $file['tmp_name'];
    $name = $file['name'];

    $fileSize = filesize($tempPath);
    $dstDir = $this->dstFileDir();
    if (!is_null($dstDir)) {
        //check if enough space left 
        $freeSpace = disk_free_space($dstDir);
        if ($freeSpace < $fileSize+1*1024*1024) {
          if ($this->isAjax())
            $this->renderAjaxError($response, "No enough space left.");
          else
            echo "No enough space left.";
          return;
        }

        $dstPath = build_file_path($dstDir, $dst_fname);
        move_uploaded_file($tempPath, $dstPath);
        chmod($dstPath, 700);
        $this->afterFileUploaded();

        // sync();
        if ($this->isAjax()) {
          $response['msg'] = "SUCCESS: File '$name' is uploaded sucessfully.";
          $this->renderAjaxSuccess($response);
        }
        else
          echo "SUCCESS: File '$name' is uploaded sucessfully.";
    } else {
      if ($this->isAjax())
        $this->renderAjaxError($response, "This platform is not supported.");
      else
        echo "This platform is not supported.";
    }
  }
  
  protected function doAjaxPost() {
    $this->genResponse();
  }

  protected function doPost() {
    echo '<textarea>';
    $this->genResponse();
    echo '</textarea>';
  }
};

$controller = new FileUploadController();
$controller->run();

?>
