<?php

set_include_path(get_include_path() . PATH_SEPARATOR . '../../app');
include_once "base_controller.php";

class DateTimeConfig extends BaseController {
  protected function signinRequired() {
    return true;
  }

  protected function adminRequired() {
    return true;
  }

  protected function doAjaxGet() {
    $response = array();
    $action = "getTimeServer";
    if (isset($_GET['action']))
      $action = $_GET['action'];

    if ($action == "getTimeServer") {
      $data = array();
      $config = getPlatformConfig();
      if (isset($config['NtpHostname']))
        $data['timeServer'] = $config['NtpHostname'];
      if (isset($config['NtpUpdateFreq']))
        $data['updateInterval'] = $config['NtpUpdateFreq'];
      if (isset($config['NtpEnable']))
        $data['enableTimeSync'] = $config['NtpEnable'];
      $response['config'] = $data;
    } else {
      $this->renderAjaxError($response, "invalid action: " . $action);
    }
    $this->renderAjaxSuccess2($response);
  }

  protected function doAjaxPost() {
    $response = array();
    $action = "updateTimeServer";
    if (isset($_POST['action']))
      $action = $_POST['action']; 

    if ($action == "updateTimeServer") {
      $timeServer = $_POST['timeServer'];
      $updateInterval = $_POST['updateInterval'];
      $enableTimeSync = $_POST['enableTimeSync'];
      if (!$this->updateTimeServerConfig($timeServer, $updateInterval, $enableTimeSync))
        $this->renderAjaxError($response, "failed to save time server config");
    } else if ($action == "syncDateTime") {
      $output = array();
      $return_var = null;
      exec("killall -s SIGUSR1 fwntp", $output, $return_var); 

      if ($return_var != 0) {
        error_log("failed to sync datetime");
        $this->renderAjaxError($response, "failed to sync datetime");
      }
    } else {
      $this->renderAjaxError($response, "invalid action: " . $action);
    }

    $this->renderAjaxSuccess2($response);
  }

  protected function updateTimeServerConfig($timeServer, $updateInterval, $enableTimeSync) {
    $config = getPlatformConfig();
    if (empty($config))
      return false;

    //assign timeserver configs
    if (is_null($timeServer))
      $timeServer = "time.windows.com";
    if (is_null($updateInterval))
      $updateInterval = 1;
    if (is_null($enableTimeSync))
      $enableTimeSync = 1;

    $config['NtpHostname'] = $timeServer;
    $config['NtpUpdateFreq'] = $updateInterval;
    $config['NtpEnable'] = $enableTimeSync;

    //write $config back to easyio.config file
    savePlatformConfig($config);
    return true;
  }
}

$controller = new DateTimeConfig();
$controller->run();

?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8" />
    <title>Change DateTime</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="../../css/bootstrap.min.css" media="screen" />
    <link rel="stylesheet" href="../../css/flatpickr.min.css" media="screen" />
    <link rel="stylesheet" href="css/datetime_config.css" media="screen" />
  </head>
  <body>
    <div class="container" id="datetime_config_content" v-cloak>
      <div class="row" style="margin-top:40px">
        <h1 style="font-family:arial, helvetica, sans-serif; font-size:300%; text-align:center; width:100%;"><a href="/utility.php" style="text-decoration:none">
        <span style="color: blue">Easy</span><span style="color: red">IO</span><span style="color: black"> FW : Change DateTime</span></a></h1>
      </div> 
      <ul class="nav nav-tabs" id="main-tabbar">
        <li v-for="sec in sections" :class="{active:isSectionActive(sec)}"><a href="#" @click="active_sec_id=sec.sec_id">{{sec.name}}</a></li>
      </ul>
      <div class="tab-content">
        <div v-for="sec in sections" class="tab-pane" :class="{active:isSectionActive(sec)}">
          <keep-alive>
            <component :is="sec.sec_id"></component> 
          </keep-alive>
        </div>
      </div>
      
    </div>

    <script type="text/x-template" id="datetime-panel-template">
      <div class="row" id="datetime_form">
        <form class="form-horizontal">
          <div class="alert" v-show="error !== null" v-cloak>
            <button type="button" class="close" @click.prevent="error = null">&times;</button>
            <strong>Error:</strong> {{ error }}
          </div>
          <div class="control-group">
            <label class="control-label" for="inputDateTime">DateTime:</label>
            <div class="controls input-append flatpickr" style="display:block">
              <input type="text" id="inputDateTime" placeholder="Select DateTime..." readonly>
              <span class='add-on' @click="fp && fp.toggle()"><i class='icon-calendar'></i></span>
            </div>
          </div>
          <div class="control-group">
            <label class="control-label" for="inputTimeZone">TimeZone:</label>
            <div class="controls" v-cloak>
              <select id="inputTimeZone" v-model="curTZ">
                <option v-for="tz in tz_list" :value="tz">
                  {{tz}}
                </option>
              </select>
            </div>
          </div>
          <div class="control-group">
            <label class="control-label" for="inputUTCOffset">UTC Offset:</label>
            <div class="controls">
              <input type="text" id="inputUTCOffset" disabled :value="utcOffsetStr">
            </div>
          </div>
          <div class="control-group">
            <label class="control-label">UTC Offset Mode:</label>
            <div class="controls">
              <label class="radio inline">
              <input type="radio" name="UTCOffsetMode" v-model="utcOffsetMode" value="OS"> OS
              </label>
              <label class="radio inline">
              <input type="radio" name="UTCOffsetMode" v-model="utcOffsetMode" value="Configuration"> Configuration
              </label>
            </div>
          </div>
          <div class="control-group">
            <div class="controls pull-right">
              <button class="btn" @click.prevent="saveConfig">Save</button>
            </div>
          </div>
        </form>
      </div>
    </script>

    <script type="text/x-template" id="ntp-panel-template">
      <div class="row">
        <form class="form-horizontal">
          <div class="alert" v-show="error !== null" v-cloak>
            <button type="button" class="close" @click.prevent="error = null">&times;</button>
            <strong>Error:</strong> {{ error }}
          </div>
          <div class="control-group">
            <div class="controls">
              <label class="checkbox">
                <input type="checkbox" v-model="enableTimeSync" true-value="1" false-value="0">Enable Network Time Sync
              </label>
            </div>
          </div>
          <div class="control-group" :class="{error: timeServerError}">
            <label class="control-label" for="inputTimeServer">Time Server:</label>
            <div class="controls">
              <input type="text" id="inputTimeServer" v-model.trim="timeServer">
              <span class="help-inline" v-show="timeServerError">Invalid Time Server Host</span>
            </div>
          </div>
          <div class="control-group" :class="{error: updateIntervalError}">
            <label class="control-label" for="inputUpdateInterval">Update Interval:</label>
            <div class="controls">
              <div class="input-append">
                <input type="number" id="inputUpdateInterval" min="1" v-model.number="updateInterval">
                <span class="add-on">Hour</span>
              </div>
              <span class="help-inline" v-show="updateIntervalError">Update Interval must be a positive number</span>
            </div>
          </div>

          <div class="control-group">
            <div class="controls pull-right">
              <button class="btn btn-info" :class="{disabled: enableTimeSync!='1'}" @click.prevent="syncDateTime">Sync</button>
              <button class="btn" @click.prevent="saveConfig">Save</button>
            </div>
          </div>
        </form>
      </div>
    </script>

    <script type="text/javascript" src="../../js/spin.min.js"></script>
    <script type="text/javascript" src="../../js/jquery-1.10.0.min.js"></script>
    <script type="text/javascript" src="../../js/underscore-min.js"></script>
    <!-- <script type="text/javascript" src="../../js/vue.min.js"></script> -->
    <script type="text/javascript" src="../../js/vue.js"></script>
    <script type="text/javascript" src="../../js/flatpickr.min.js"></script>
    <script type="text/javascript" src="../../js/date.min.js"></script>
    <script type="text/javascript" src="js/datetime_config.js"></script>
  </body>
</html>
