(function() {
  
  var UserLibClass = function() 
  {
    // define javascript methods that will be called when widget need to be initialized or data updated. 
    // in these methods' context, beside jQuery, following variables are accessible:
    //   * this.elem       - parent DOM element 
    //   * User Properties - you can define user property on AdapterWidget in CPT:
    //                        1. select a AdapterWidget object 
    //                        2. right click in the property editor
    //                        3. choose "New User Property" menu item
    //                       NOTE: all user defined properties start with '@'. 
    //                       To read a user property's value: this.readData("@UserPropertyName");
    //                       To write a user property's value: this.writeData("@UserPropertyName", value);
    //                       To invoke an action: this.invokeAction("ActionSlotPath") or this.invokeAction("ActionSlotPath", value)
    //
    //
    // [optional] if this method defined, it should return a array of required javascript and css files
    this.requiredScripts = function() {   
      // *Note*, you need to put the javascript files under CPT/grweb/public/user_codes folder
      //         manually, otherwise these files cannot be deployed to device
      return ["../user_codes/slideControl/slideControl.css",
              "../user_codes/slideControl/jquery.slideControl.min.js"];
    };
    
    this.getReadDelayAfterWrite = function() {
      var delay = this.readData("@ReadDelayAfterWrite");
      if (typeof this.isDashboard !== 'function' || !this.isDashboard()) {
        //CPT Graphics does not support enum with customized values, 
        //so we need to convert from index to value here. Yes, it sucks 
        delay = [15000, 30000, 60000][delay];
      }
      else {
        if (delay === null || Number.isNaN(_.str.toNumber(delay)))
          delay = 15000;
        else
          delay = _.str.toNumber(delay)*1000;
      }
      return delay;
    };
    
    this.changeData = function() {
        var _this = this;
        if (!this.isDataChanged())
        {
          this.stopUpdate = false;
          return;
        }
    
        var delay = this.getReadDelayAfterWrite();
          
        if (this.updateTimer !== null) {
          clearTimeout(this.updateTimer);
          this.updateTimer = null;
        }
        
        //delay data update after *BOTH* configured delay time and request completed
        var enableDataUpdate = _.after(2, function() { 
          _this.stopUpdate = false;
          if (typeof _this.isDashboard !== 'function' || !_this.isDashboard())
            _this.update("@data");
        });
        this.updateTimer = setTimeout(enableDataUpdate, delay);
    
        var settings = {'complete': enableDataUpdate};
        this.stopUpdate = true;
        if (_.str.isBlank(this.setPointPath))
          this.writeData("@data", $(this.elem).find(".slideControl").val(), settings);
        else
          this.invokeAction(this.setPointPath, $(this.elem).find(".slideControl").val(), null, settings);
    };
    
    this.isDataChanged = function() {
      var val = this.readData("@data");
      //only update data when it's changed 
      return val != $(this.elem).find(".slideControl").val();
    };
    
    // [required] when required javascripts loaded successfully, this method will be called to initialize the widget
    this.init = function() { 
        this.stopUpdate = false;
        this.setPointPath = this.readData("@SetPoint");
        this.updateTimer = null;
        this.setupUI();
        
        $(this.elem).on('settingsChanged', _.bind(this.setupUI, this));
        this.update("@data");
    }
    
    this.setupUI = function() {
      if (this.updateTimer !== null) {
        clearTimeout(this.updateTimer);
        this.updateTimer = null;
      } 
      $(this.elem).empty();
      
      this.minVal = _.str.toNumber(this.readData("@LowerBound"));
      this.maxVal = _.str.toNumber(this.readData("@UpperBound"));
    
      $("<label></label><input type='text' value='0' class='slideControl' />").appendTo($(this.elem));
      var slideControl = $(this.elem).find(".slideControl").slideControl({
          lowerBound: this.minVal, 
          upperBound: this.maxVal});
      $(this.elem).find(".slideControlContainer").width($(this.elem).width()-64)
      this.update("@data");
    
      var _this = this;
      var onDataChangeHandler = _.debounce(_.bind(this.changeData, this), 750);
      $(this.elem).find(".slideControl").on("slide.change", function() {
        if (_this.isDataChanged())
        {
          _this.stopUpdate = true;
          onDataChangeHandler();
        }
        else
        {
          _this.stopUpdate = false;
        }
      }).on("focusin", function() { 
        _this.stopUpdate = true; 
      }).on("focusout", function() { 
        if (!_this.isDataChanged())
          _this.stopUpdate = false; 
      })
    };
    
    
    // [required] when user property changed, this callback method will be called
    // it is a good place to update widget with new data, you can read user property's name by:
    // this.readData("@UserPropertyName")
    this.update = function(userPropertyName) {
      if (this.stopUpdate || userPropertyName != "@data")
        return;
    
      var val = this.readData(userPropertyName);
      if (_.isNaN(_.str.toNumber(val)))
        return;
        
      if (val < this.minVal || val > this.maxVal) {
        $(this.elem).trigger("widget.error", "Out of range");
        return;
      }
      else
        $(this.elem).trigger("widget.ok");
        
      var slider =  $(this.elem).find(".slideControl");
      val = Math.max(Math.min(val, this.maxVal), this.minVal);
      if (val != slider.val())
        slider.val(val).change();
    };
    
    // [required] put possible clean up codes here
    this.cleanup = function() {
    };    
  };

  var userLib = new UserLibClass();
  var external_scripts = _.has(userLib, 'requiredScripts') ? userLib.requiredScripts() : [];
  if (external_scripts == null)
    external_scripts = [];
  external_scripts.push("../js/underscore.string.min.js");

  //TODO: generate settings from user_lib
  freeboard.loadWidgetPlugin({
    'external_scripts': external_scripts,
    'fill_size': false,
    'type_name': 'CPT_Sliders_LineSlider1_Widget',
    'display_name': 'LineSlider1',
    'description': 'LineSlider1 Widget converted from CPT Graphics'    ,
    'settings': [
      {
        'name': '@LowerBound',
        'display_name': '@LowerBound',
        'type': 'calculated',
        'default_value': '0',
        'editor': ''
      },
      {
        'name': '@ReadDelayAfterWrite',
        'display_name': '@ReadDelayAfterWrite',
        'type': 'option',
        'options': [{'name': 'Normal', 'value': '15'},{'name': 'Slow', 'value': '30'},{'name': 'Very Slow', 'value': '60'}],
        'default_value': '15',
        'editor': ''
      },
      {
        'name': '@SetPoint',
        'display_name': '@SetPoint',
        'type': 'calculated',
        'default_value': '',
        'editor': 'action'
      },
      {
        'name': '@UpperBound',
        'display_name': '@UpperBound',
        'type': 'calculated',
        'default_value': '100',
        'editor': ''
      },
      {
        'name': '@data',
        'display_name': '@data',
        'type': 'calculated',
        'default_value': '',
        'editor': ''
      },
      {
        'name': 'rows',
        'display_name': 'Rows',
        'type': 'option',
        'default_value': '1',
        'options': [{'name': '1 row', 'value': 1}, {'name': '2 rows', 'value': 2}, {'name': '3 rows', 'value': 3}, {'name': '4 rows', 'value': 4}, {'name': '5 rows', 'value': 5}, {'name': '6 rows', 'value': 6}, {'name': '7 rows', 'value': 7}, {'name': '8 rows', 'value': 8}]
      }      
    ], 
    newInstance: function(settings, newInstanceCallback)
    {
      var wa = new WidgetAdapter(settings);
      wa = _.extend(wa, new UserLibClass());
      newInstanceCallback(wa);
    }
  });

})();
