ajaxCompleteHandler = (event, xhr, settings) ->
  if (settings.dataType.toLowerCase() != "json" || xhr.responseText.length == 0 || settings.crossDomain)
    return
  
  obj = null
  try
    obj = JSON.parse(xhr.responseText)
  catch err
    console.error("can not parse json request: " + err.message)
    return

  if (obj.redirect)
    if /signin\.php$/.test(obj.redirect)
      window.location.href = obj.redirect + "?success_url=" + window.location.href
      return
      
  if /data_api\.php/.test(settings.url) && obj.response?.errorMsg?.length > 0
    iziToast.warning
      title: "Data Update Error"
      message: obj.response.errorMsg
      
updateQueryString = (key, value, url)->
   url = window.location.href unless url
   re = new RegExp("([?&])" + key + "=.*?(&|#|$)(.*)", "gi")

   if (re.test(url))
       if value?
           return url.replace(re, '$1' + key + "=" + value + '$2$3')
       else
           hash = url.split('#')
           url = hash[0].replace(re, '$1$3').replace(/(&|\?)$/, '')
           anchor = hash[1]
           if anchor?
               url += '#' + hash[1]
           return url
   else
       if value?
           separator = if url.indexOf('?') isnt -1 then '&' else '?'
           hash = url.split('#')
           url = hash[0] + separator + key + '=' + value
           anchor = hash[1]
           if anchor?
               url += '#' + hash[1]
           return url
       else
           return url

closeFreeboardDialog = ->
  $("#modal_overlay").fadeOut(200, ->
    $(this).remove()
  )
  
isDashboardModified = ->
  elem = document.getElementById('contentJson')
  return true unless elem?.innerHTML?

  oldContent = $.trim(elem.innerHTML)

  dashboardData = freeboard.serialize()
  newContent = JSON.stringify(dashboardData)
  
  return oldContent != newContent

h4 = (msg)->
  "<h4>" + msg + "</h4>"
    

class JsTreeModel

  constructor: (isActive)->
    @isActive = isActive

  L: (str)->
    l18n(str, "page.js")

  create: (dashboardList)->
    nodes = []
    for dashboard in dashboardList
      nodes.push @createNode(dashboard)

    $(document).on('dnd_stop.vakata', @onDndStop)

    jstree_conf =
      core:
        multiple: false
        themes:
          dots: false
          responsive: false
        check_callback: (operation, node, node_parent, node_position, more)->
          # operation can be 'create_node', 'rename_node', 'delete_node', 'move_node' or 'copy_node'
          # operation === 'rename_node' ? true : false;
          node_parent != "#"
        data: nodes
      plugins: ["unique"]
      # dnd:
      #   touch: 'selected'
      #   large_drop_target: true
      #   large_drag_target: true
        
    if window.perms.canManageWidget
      jstree_conf.plugins.push("dnd")
      jstree_conf.plugins.push("contextmenu")
      jstree_conf.contextmenu =
        select_node: false
        items: (node, callback)=>
          obj =
            rename:
              label: @L("Rename")
              action: @renameNode
            delete:
              label: @L("Delete")
              action: @deleteNode
          return obj if node.parent != '#'

    $("#jstree").jstree jstree_conf
          
  isTopNode: (parent_id)=>
    _.isEmpty(parent_id) or parent_id == '0' or parent_id == '#'
            
  createNode: (board)->
    icon = @isTopNode(board.parent_id) and 'jstree-folder' or 'jstree-file'
    child =
      id: board.id
      parent: @isTopNode(board.parent_id) and "#" or board.parent_id
      text: board.name
      icon: icon
      state:
        selected: @isActive(board.id)
        opened: @isTopNode(board.parent_id)
        
  boardName: (id)->
    inst = $("#jstree").jstree(true)
    inst?.get_node(id)?.text
        
  layoutData: (id)->
    inst = $("#jstree").jstree(true)
    node = inst.get_node(id)

    parent = inst.get_node(node.parent)
    children = parent.children
    data =
      id: id
      parent_id: parent.id
      sibling_ids: children.join(",")

  onDndStop: (event, data)=>
    return unless data?.data?.nodes?.length > 0
    layout_data = @layoutData(data.data.nodes[0])

    layout_data['action'] = 'layout'

    $.ajax
      url: "index.php"
      method: "POST"
      dataType: "json"
      data: layout_data

  onNodeRenamed: (node, status, cancelled, old_text)=>
    return unless status and !cancelled

    unless /^[-_a-zA-Z0-9]{1,64}$/.test(node.text)
      inst = $.jstree.reference("#jstree")
      inst.set_text(node, old_text)
      return
    
    $.ajax
      url: "index.php"
      method: "POST"
      dataType: "json"
      data:
        action: "rename"
        id: node.id
        new_name: node.text
      success: (data)=>
        inst = $.jstree.reference("#jstree")
        if data.error?
          console.warn("failed to rename node: " + old_text + " to " + node.text)
        else
          window.curDashboardId = node.id
        
  renameNode: (node)=>
    inst = $.jstree.reference(node.reference)
    obj = inst.get_node(node.reference)
    old_text = obj.text
    inst.edit(obj, obj.text, (node, status, cancelled)=>
      @onNodeRenamed(node, status, cancelled, old_text)
    )
    
  doDeleteNode: (node)->
    inst = $.jstree.reference(node.reference)
    obj = inst.get_node(node.reference)
    id_list = [obj.id]
    inst.delete_node(obj)

    $.ajax
      url: "index.php"
      method: "POST"
      dataType: "json"
      data:
        action: "delete"
        id_list: id_list.join(",")
      success: (data)=>
        if data.error?
          console.warn("failed to delete node")
        else
          inst = $.jstree.reference("#jstree")
          topNode = inst.get_node("1")
          if topNode.children? and topNode.children.length > 0
            inst.activate_node(topNode.children[0])
          else
            $('#jstree').trigger("AllNodeRemoved")

  deleteNode: (node)=>
    inst = $.jstree.reference(node.reference)
    obj = inst.get_node(node.reference)
    freeboard.showDialog(@L("<h4>Are you sure to delete dashboard '")+obj.text+"' ?</h4>", @L("Confirm to delete"), @L("Yes"), @L("No"),
      =>
        @doDeleteNode(node)
    )

  addNode: (board)->
    return unless board?

    jstree = $("#jstree").jstree(true)
    node = jstree.get_node(board.id)
    return if node

    root = jstree.get_node("1")
    node = jstree.create_node(root, @createNode(board))
    jstree.deselect_all()
    jstree.select_node(node)
    
  checkUniqueness: (name)->
    inst = $("#jstree").jstree(true)
    root = inst.get_node("1")
    if not root.children? or root.children.length <= 0
      return true
    
    for child in root.children
      if inst.get_node(child).text == name
        return false
      
    return true


class DashboardManager

  constructor: ->
    @prevDataSources = null
    @jsTreeModel = new JsTreeModel((id)=>
      id == window.curDashboardId
    )

    $('#jstree').on('AllNodeRemoved', @onAllNodeRemoved)

    @nameViewModel =
      name: ko.observable('default')
      error_msg: ko.observable('')
      
    @render()

  L: (str)->
    l18n(str, "page.js")
    
  render: ->
    elem = document.getElementById('contentJson')
    if elem?.innerHTML?
      content = $.trim(elem.innerHTML)
      if content.length == 0
        redirect_url = window.location.origin + window.location.pathname
        if redirect_url != window.location.href
          window.location.href = redirect_url
        else
          @newDashboard(false)
      else
        jsonContent = JSON.parse(content)
        freeboard.loadDashboard(jsonContent, =>
          freeboard.setEditing(false)
        )
    else
      @newDashboard()

  loadDashboard: (id)->
    return unless id?
    
    # freeboard.showLoadingIndicator(true)
    window.location.href = updateQueryString('dashboard_id', id)
        
  onDashboardsLoaded: (data)=>
    if data.response? and data.response.length > 0
      $("#jstree").on('activate_node.jstree', (e, data) =>
        node = data?.node
        instance = data?.instance
        if node?.parent == '#'
          # never select folder node
          instance.toggle_node(node)
          instance?.deselect_node(data?.node?.id, true)
          instance?.select_node(window.curDashboardId, true)
        else
          @loadDashboard node?.id
      )
      @jsTreeModel.create(data.response)
    else
      freeboard.setEditing(true)

  loadDashboards: ->
    $.ajax
      dataType: "json"
      url: "index.php"
      data:
        action: "list"
      beforeSend: ->
        freeboard.showLoadingIndicator(true)
      success: @onDashboardsLoaded
      complete: ->
        freeboard.showLoadingIndicator(false)

  newDashboard: (cancelBtn=true)=>
    unless window.perms.canManageWidget
      console.warn("can not create dashboard: permission denied")
      return

    dom = $($('#name_dialog_tpl').html())
    ko.applyBindings(@nameViewModel, dom[0])
    cancelText = if cancelBtn then @L("Cancel") else null
    freeboard.showDialog(dom, @L("New Dashboard Name"), @L("Save"), cancelText,
      =>
        name = @nameViewModel.name()
        if not /[-_a-zA-Z0-9.]+/.test(name)
          @nameViewModel.error_msg(@L("invalid dashboard name. (valid characters: alpha, number, _ and -)"))
          return true
        else if not @jsTreeModel.checkUniqueness(name)
          @nameViewModel.error_msg(@L("dashboard's name alreay exists"))
          return true
        else
          if window.curDashboardId
            @prevDataSources = freeboard.serialize().datasources

          freeboard.newDashboard()
          @doSaveDashboard(null, name)
          freeboard.setEditing(false)
          return false
    )
    
  doSaveDashboard: (id, name)->
    console.info("save dashboard: " + name)
    dashboardData = freeboard.serialize()
    dashboardData.datasources = @prevDataSources if @prevDataSources
    @prevDataSources = null
    content = JSON.stringify(dashboardData)
    data =
      action: 'save'
      name: name
      content: content
    data.id = id if id?
    $.ajax "index.php",
      data: data
      dataType: "json"
      method: "POST"
      beforeSend: ->
        freeboard.showLoadingIndicator(true)
      success: (data)=>
        if data.redirect?
          window.location.href = data.redirect
        else
          if data.error?
            # display error message 
            console.warn("can not save dashboard")
          else
            console.info("dashbaord saved")
            freeboard.setEditing(false)

            elem = document.getElementById('contentJson')
            elem.innerHTML = content if elem?.innerHTML?
        # board =
        #   id: data?.response?.id
        #   name: name
        #   parent_id: '1'
        # @jsTreeModel.addNode(board)
      complete: ->
        freeboard.showLoadingIndicator(false)

  saveDashboard: ->
    if window.curDashboardId
      @doSaveDashboard(window.curDashboardId, @jsTreeModel.boardName(window.curDashboardId))
    else
      @saveDashboardAs()

  saveDashboardAs: ->
    dom = $($('#name_dialog_tpl').html())
    ko.applyBindings(@nameViewModel, dom[0])
    freeboard.showDialog(dom, @L("Dashboard Name"), @L("Save"), @L("Cancel"),
      =>
        name = @nameViewModel.name()
        if not /[-_a-zA-Z0-9.]+/.test name
          @nameViewModel.error_msg(@L("invalid dashboard name. (valid characters: alpha, number, _ and -)"))
          return true
        else if not @jsTreeModel.checkUniqueness(name)
          @nameViewModel.error_msg(@L("dashboard's name alreay exists"))
          return true
        else
          @doSaveDashboard(null, name)
          freeboard.setEditing(false)
          return false
    )
    
  onAllNodeRemoved: =>
    @newDashboard(false)
    
class SidebarControl

  constructor: ->
    @el = $("#sidebar_toggle_btn")
    @el.mouseenter(@highlight)
    @el.mouseleave(@unhighlight)

    @slideout = new Slideout(
      'panel': document.getElementById('dashboard_panel')
      'menu': document.getElementById('sidebar')
      # 'touch': false # disable touch to slideout 
      'padding': 200
    )

    @el.click =>
      @slideout.toggle()
      
    @slideout.on('open', =>
      @el.text("-")
    )
    @slideout.on('close', =>
      @el.text("+")
    )
    
  highlight: =>
    @el.css
      'color': "#B88F51"
      'border-color': "#B88F51"
      'cursor': 'pointer'

  unhighlight: =>
    @el.css
      'color': "rgba(128,128,128,0.3)"
      'border-color': 'rgba(128,128,128,0.3)'
      'cursor': 'auto'
      
  enableTouch: (enable)=>
    if enable
      @slideout.enableTouch()
    else
      @slideout.disableTouch()

class PermEntry
  constructor: (dashboardId, pageName, canManageDataSource, canManageWidget, canViewDashboard, canWriteDataSource)->
    @dashboardId = dashboardId
    @pageName = pageName
    @canManageDataSource = ko.observable(canManageDataSource == 't')
    @canWriteDataSource = ko.observable(canWriteDataSource == 't')
    @canManageWidget = ko.observable(canManageWidget == 't')
    @canViewDashboard = ko.observable(canViewDashboard == 't')
    
  postData: ->
    dashboardId: @dashboardId
    canManageDataSource: if @canManageDataSource() then 't' else 'f'
    canWriteDataSource: if @canWriteDataSource() then 't' else 'f'
    canManageWidget: if @canManageWidget() then 't' else 'f'
    canViewDashboard: if @canViewDashboard() then 't' else 'f'
      
class PermissionViewModel
  
  constructor: ->
    btnElem = $("#permission_control_btn")
    btnElem.click @showPermUI
    @viewModel = null
    
  L: (str)->
    l18n(str, "page.js")
    
  renderPermData: (resp)->
    return unless resp?
    
    prevUserName = @viewModel.selectedUser().userName if @viewModel?.selectedUser?
    @viewModel =
      selectedUser: ko.observable()
      users: []
      error_msg: ko.observable('')

    for entry in resp
      found = false
      permEntry = new PermEntry(entry.dashboardId, entry.pageName, entry.canManageDataSource, entry.canManageWidget, entry.canViewDashboard, entry.canWriteDataSource)
      for u in @viewModel.users when u.userName == entry.userName
        found = true
        u.perms.push(permEntry)
      unless found
        modelEntry =
          userId: entry.userId
          userName: entry.userName
          perms: [permEntry]
        @viewModel.users.push modelEntry
        @viewModel.selectedUser(modelEntry) if prevUserName == entry.userName

    dom = $($('#user_perm_tpl').html())
    ko.applyBindings(@viewModel, dom[0])
    freeboard.showDialog(dom, @L("Manage Permission"), @L("Save"), @L("Cancel"), @savePerm)

  showPermUI: =>
    freeboard.showLoadingIndicator(true)
    $.ajax
      url: "permission_controller.php"
      method: "GET"
      dataType: "json"
      success: (data)=>
        if data.error?
          console.warn("failed to get permission data, error: "+data.error)
        else
          @renderPermData(data.data)
      error: (data, status)->
        console.warn("failed to get permission data: "+status)
      complete: (data, status)->
        freeboard.showLoadingIndicator(false)
        
  savePerm: =>
    userData = @viewModel.selectedUser()
    data =
      user_id: userData.userId
      perms: perm.postData() for perm in userData.perms
      
    freeboard.showLoadingIndicator(true)
    $.ajax
      url: 'permission_controller.php'
      method: 'POST'
      dataType: 'json'
      data: data
      success: (data) ->
        if data.error?
          console.warn("failed to save permission data")
      error: (data, status)->
        console.warn("failed to save permission data: "+status)
      complete: (data, status)->
        freeboard.showLoadingIndicator(false)
    return false

class AccountViewModel
  
  constructor: ->
    btnElem = $("#account_control_btn")
    btnElem.click @showAccountUI
    @viewModel = null
    
  L: (str)->
    l18n(str, "page.js")
    
  renderAccountData: (resp)->
    return unless resp?

    prevUserName = @viewModel.selectedUser().userName if @viewModel?.selectedUser?
    @viewModel =
      selectedUser: ko.observable()
      users: []
      error_msg: ko.observable('')

    for user in resp
      found = false
      for u in @viewModel.users when u.userName == user.name
        found = true
      unless found
        model =
          userId: user.user_id
          userName: user.name
          newPassword: ''
          verifyPassword: ''

        @viewModel.users.push(model)
        @viewModel.selectedUser(model) if prevUserName == user.name

    dom = $($('#user_account_tpl').html())
    ko.applyBindings(@viewModel, dom[0])
    freeboard.showDialog(dom, @L("Manage Account"), @L("Save"), @L("Cancel"), @saveAccount)
    
  showAccountUI: =>
    freeboard.showLoadingIndicator(true)
    $.ajax
      url: "../app/account_management.php"
      method: "GET"
      dataType: "json"
      success: (data)=>
        if data.error?
          console.warn("failed to get account data, error: "+data.error)
        else
          @renderAccountData(data.data)
      error: (data, status)->
        console.warn("failed to get account data: "+status)
      complete: (data, status)->
        freeboard.showLoadingIndicator(false)
        
  validatePassword: =>
    @viewModel.error_msg('')
    userData = @viewModel.selectedUser()

    if userData.newPassword != userData.verifyPassword
      @viewModel.error_msg(@L("inputed passwords are different"))
      return false
    
    if userData.newPassword.length < 8
      @viewModel.error_msg(@L("password must be at least 8 characters"))
      return false
    
    return /^\w{8,}$/.test(userData.newPassword)
        
  saveAccount: =>
    userData = @viewModel.selectedUser()

    return true unless @validatePassword()

    freeboard.showLoadingIndicator(true)
    $.ajax
      url: "../app/account_management.php?user_id=#{userData.userId}"
      method: "POST"
      dataType: "json"
      data:
        action: "updateAccount"
        user:
          id: userData.userId
          password: userData.newPassword
      success: closeFreeboardDialog
      complete: (data, status)->
        freeboard.showLoadingIndicator(false)
        
        
class BackupViewModel
  
  constructor: ->
    btnElem = $("#backup_btn")
    btnElem.click @showBackupPanel
    @viewModel = null
    
  L: (str)->
    l18n(str, "page.js")
    
  showBackupPanel: =>
    @viewModel = 
      name: ko.observable(moment().format("YYYYMMDD")+"_backup")
      backupNetworkConf: ko.observable(true)
      msg: ko.observable('')
      is_error: ko.observable(false)

    dom = $($('#backup_panel_tpl').html())
    ko.applyBindings(@viewModel, dom[0])
    freeboard.showDialog(dom, @L("Backup"), @L("Backup"), @L("Close"), @doBackup)
    
  validateName: ->
    if /^[_0-9a-zA-Z]+$/.test(@viewModel.name())
      @viewModel.msg('')
      return true
    else
      @viewModel.is_error(true)
      @viewModel.msg("<h4>" + @L("backup name can only include number, character and underscore.") + "</h4>")
      return false
    
  doBackup: =>
    return true unless @validateName()
    
    $.ajax
      url: "../app/utility.php"
      method: "POST"
      dataType: "json"
      data:
        action: 'backup'
        data:
          name: @viewModel.name()
          type: 'flash'
          dataOnly: true
          backupHistoryDB: true
          backupNetworkConf: @viewModel.backupNetworkConf()
      beforeSend: =>
        @viewModel.is_error(false).msg("<h4>"+@L("Make backup '{name}'...").supplant(name:@viewModel.name())+"</h4>")
        freeboard.showLoadingIndicator(true)
      success: (data)=>
        if data.error
          @viewModel.is_error(true)
          @viewModel.msg("<h4>"+data.error.text+"</h4>")
        else
          @viewModel.is_error(false)
          @viewModel.msg("<h4>"+@L("Backup is done")+"</h4>")
      error: (data, status)=>
        @viewModel.is_error(true)
        @viewModel.msg("<h4>"+@L("Backup failed: ")+status+"</h4>")
      complete: ->
        freeboard.showLoadingIndicator(false)

    return true
    
class RestoreViewModel
  
  constructor: ->
    btnElem = $("#restore_btn")
    btnElem.click @loadBackups
    @viewModel = null
    
  L: (str)->
    l18n(str, "page.js")

  initViewModel: =>
    @viewModel =
      backups: ko.observableArray()
      msg: ko.observable('')
      is_error: ko.observable(false)
      restoreBackup: @restoreBackup
      downloadBackup: @downloadBackup
      deleteBackup: @deleteBackup

  loadBackups: =>
    @initViewModel()

    $.ajax
      type: 'GET'
      url: "../app/utility.php"
      dataType: 'json'
      data:
        action: 'list_backups'
      beforeSend: ->
        freeboard.showLoadingIndicator(true)
      success: (data)=>
        if data.backups
          for b in _.sortBy(data.backups, 'ts').reverse()
            b.restoreNetworkConf = false
            @viewModel.backups.push(b)
          if @viewModel.backups().length == 0
            @viewModel.is_error(false).msg("<h4>"+@L("No backup available.")+"</h4>")
          @createRestorePanel()
        else
          @viewModel.is_error(true).msg(@L("Wrong response format: ")+JSON.stringify(data))
      error: (data, status)=>
        @viewModel.is_error(true).msg("<h4>"+@L("List backups failed: ")+status+"</h4>")
      complete: ->
        freeboard.showLoadingIndicator(false)
        
  createRestorePanel: ->
    dom = $($('#restore_panel_tpl').html())
    ko.applyBindings(@viewModel, dom[0])
    freeboard.showDialog(dom, @L("Restore"), null, @L("Close"))
    
  downloadBackup: (backup)=>
    window.open('../app/utility.php?action=download&data[name]='+backup.name+'&data[type]='+backup.type, '_blank')

  deleteBackup: (backup)=>
    @viewModel.msg('')

    confirmed = confirm(L("Are you sure to delete backup '{name}' ?").supplant(name: backup.name))
    return unless confirmed

    $.ajax
      type: "POST"
      url: "../app/utility.php"
      dataType: 'json'
      data:
        action: 'delete'
        data:
          name: backup.name
          type: backup.type
      beforeSend: =>
        @viewModel.is_error(false).msg("<h4>"+@L("Delete backup '{name}' ...").supplant(name:backup.name)+"</h4>")
        freeboard.showLoadingIndicator(true)
      success: (data)=>
        if data.error
          @viewModel.is_error(true).msg("<h4>"+data.error.text+"</h4>")
        else
          @viewModel.is_error(false).msg(L("<h4>Backup '{name}' is deleted!</h4>").supplant
            name: backup.name
          )
          @viewModel.backups.remove(backup)
      error: (data, status)=>
        @viewModel.is_error(true).msg("<h4>"+L("Failed to delete backup '{name}': {error}").supplant
          name: backup.name
          error: status
        +"</h4>")
      complete: =>
        freeboard.showLoadingIndicator(false)

  restoreBackup: (backup)=>
    @viewModel.msg('')

    $.ajax
      type: "POST"
      url: "../app/utility.php"
      dataType: "json"
      data:
        action: 'restore'
        data:
          name: backup.name
          type: backup.type
          withNetworkConf: backup.restoreNetworkConf
      beforeSend: =>
        @viewModel.is_error(false).msg("<h4>"+@L("Restore to backup '{name}' ...").supplant(name:backup.name)+"</h4>")
        freeboard.showLoadingIndicator(true)
      success: (data)=>
        if data.error
          @viewModel.is_error(true).msg("<h4>"+data.error.text+"</h4>")
          freeboard.showLoadingIndicator(false)
        else
          @viewModel.is_error(false).msg("<h4>"+L("<h4>Succeed restoring to backup '{name}'!</h4>reloading now, please wait ...").supplant(name: backup.name)+"</h4>")

          _.delay(->
            location.reload()
          , 2000)
      error: (data, status)=>
        @viewModel.is_error(true).msg("<h4>"+L("Failed to restore backup '{name}': {error}").supplant
          name: backup.name
          error: status
        +"</h4>")
        freeboard.showLoadingIndicator(false)
        

class UploadViewModel
  constructor: ->
    btnElem = $("#upload_btn")
    btnElem.click @showUploadPanel
    @viewModel = null
    @elem = null
    
  L: (str)->
    l18n(str, "page.js")
    
  showUploadPanel: =>
    @viewModel =
      msg: ko.observable('')
      is_error: ko.observable(false)
      state: ko.observable('ready')
      restoreNetworkConf: ko.observable(false)
      onUpload: @onUpload
      onUploadRestore: @onUploadRestore

    dom = $($('#upload_panel_tpl').html())
    ko.applyBindings(@viewModel, dom[0])
    freeboard.showDialog(dom, @L("Upload"), null, @L("Close"))
    @elem = dom
    
  validateFile: (file)->
    unless file
      @viewModel.is_error(true).msg(h4(@L("Please select a file first")))
      return false

    name = file.name
    if /\.tgz+$/.test(name)
      @viewModel.is_error(false).msg('')
      return true
    else
      @viewModel.is_error(true).msg(h4(@L("Upload file must end with '.tgz'(gzipped tar)")))
      return false
    
  onUpload: =>
    @doUpload()
    
  onUploadRestore: =>
    @doUpload(true)

  doUpload: (restoreNow)=>
    data =
      action: 'upload'
      'data[type]': 'flash'
      'data[withNetworkConf]': @viewModel.restoreNetworkConf

    data['data[restoreNow]'] = 'true' if restoreNow

    @elem.find('form').ajaxSubmit
      type: 'POST'
      url: '../app/utility.php'
      data: data
      dataType: 'json'
      beforeSubmit: (arr, form, options)=>
        index = -1
        i = 0
        for a in arr
          if a.name == 'backupTarBall'
            index = i
            break
          else
            ++i

        if index == -1
          @viewModel.is_error(true).msg(h4(L('Invalid form data')))
          return false

        if arr[index].name == 'backupTarBall'
          return false unless @validateFile(arr[index].value)

          @viewModel.is_error(false).msg(h4(L('Uploading file ...'))).state('uploading')
          # @elem.find('.cssProgress').show()
          # @elem.progress_fnc(type: 'reset')
          freeboard.showLoadingIndicator(true)
          return true
      uploadProgress: (event, pos, total, percentComplete)=>
        @viewModel.msg(h4(L('Uploading file ({percent}%) ...').supplant(percent: percentComplete)))
        if percentComplete == 100
          @viewModel.msg(h4(L("Uploaded. Start to unpack it ...")))
        # @elem.find('.cssProgress-bar').data('percent', percentComplete)
        # @elem.progress_fnc()
      success: (data, statusText, xhr, form)=>
        if data.redirect?
          window.location.href = data.redirect
        else
          if data.error?
            @viewModel.is_error(true).msg(hr(data.error.text))
          else
            if data.msg?
              @viewModel.is_error(false).msg(h4(data.msg))
            else
              @viewModel.is_error(false).msg(h4(L("All Done!")))
              
            if data.reloadRequired? and data.reloadRequired
              _.delay(=>
                @viewModel.is_error(false).msg(h4(L("Reloading now ...")))
                location.reload()
              , 2000)
            # @elem.find('.cssProgress-bar').data('percent', 100)
        # check if response is success, if not, reset UI state 
      complete: =>
        @viewModel.state('ready')
        freeboard.showLoadingIndicator(false)

    return true


widgetUrls = ["js/freeboard_plugins.min.js", "plugins/cpt/cpt.datasources.js", "plugins/mqtt/paho.mqtt.plugin.js"]
widgetUrls = widgetUrls.concat(window.cptWidgets) if window.cptWidgets?
head.js(widgetUrls,
        ->
          # start jquery initialization
          $(->
            $(document).ajaxComplete(ajaxCompleteHandler)
            freeboard.initialize(window.perms.canManageDataSource || window.perms.canManageWidget)

            window.manager = new DashboardManager
            window.sidebarControl = new SidebarControl
            window.permViewModel = new PermissionViewModel
            window.accountViewModel = new AccountViewModel
            window.backupViewModel = new BackupViewModel
            window.restoreViewModel = new RestoreViewModel
            window.uploadViewModel = new UploadViewModel

            $(window).trigger("uiReady")

            manager.loadDashboards()
            
            # ask user to confirm leaving 
            $(window).on('beforeunload', (e)->
              enableConfirmOnClose = Cookies.get("UIOption.enableConfirmOnClose");
              if enableConfirmOnClose
                enableConfirmOnClose = enableConfirmOnClose=='true'
              else
                enableConfirmOnClose = true
              return undefined unless (enableConfirmOnClose && isDashboardModified())
              
              # if user cancel the leaving, restore sth
              _.defer ->
                inst = $("#jstree").jstree(true)
                return unless inst

                selected_ids = inst.get_selected()
                inst.deselect_node(selected_ids)
                inst.select_node(window.curDashboardId, true)

              confirmMessage = "Do you want to leave this page ?"
              (e || window.event).returnValue = confirmMessage
              return confirmMessage
            )
            
            $(window).on('unload', ->
              # if user decides to leave, just show loading indicator
              freeboard.showLoadingIndicator(true)
            )

            # extend jquery function for progress bar
            $.fn.progress_fnc = (options)->
              settings = $.extend
                type: 'start'
              , options
              div = $(this)
              progress = div.find('.cssProgress')
              progress.each(->
                self = $(this)
                progress_bar = self.find('.cssProgress-bar')
                progress_label = self.find('.cssProgress-label, .cssProgress-label2')
                progress_value = progress_bar.data('percent')
                percentage = parseInt(progress_value, 10)+'%'
                
                progress_bar.css({'transition': 'none', '-webkit-transition': 'none', '-moz-transition': 'none'})
                
                if (settings.type == 'start')
                  progress_bar.width(percentage)
                  progress_label.text(percentage)
                else if (settings.type == 'reset')
                  progress_bar.css('width', '0%')
                  progress_label.text('0%')
                else
                  console.warn("invalid settings.type: " + settings.type)
              )
            
          ) # end jquery initialization
        )

# vim: ts=2 sw=2 softtabstop=1
