<?php
//vim: ts=2 sw=2

include_once "db.php";
include_once "base_controller.php";

class SignoutController extends BaseController {

  public function doGet() {
    unset($_SESSION['user_id']);
    unset($_SESSION['user_name']); 
    unset($_SESSION['last_visit_time']); 

    $this->signoutPhpLiteAdmin();

    $this->redirect($this->makeUrl('app/signin.php'));
  }

  public function doAjaxGet() {
    $response = array();

    unset($_SESSION['user_id']);
    unset($_SESSION['user_name']); 
    unset($_SESSION['last_visit_time']); 

    $this->signoutPhpLiteAdmin();

    $this->renderAjaxSuccess($response);
  }

  protected function signinRequired() {
    return true;
  }
}

$controller = new SignoutController();
$controller->run();

?>
