<?php
//vim: ts=2 sw=2

include_once "db.php";
include_once "base_controller.php";

class LandingPageController extends BaseController {
  protected function signinRequired() {
    return true;
  }
  
  protected function doGet() {
    if (!isset($_GET['permission_error']))
        $this->redirect($this->userHomePage());
  }
}

$controller = new LandingPageController();
$controller->run();

?>

<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8" />
    <title><?php echo Config::$webPageTitle ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="../css/bootstrap.min.css" media="screen" />
  </head>
  <body>
    <div class="container">
      <?php 
        if(!is_null($controller->flash()))
          echo '<div class="alert">' . $controller->flash() . '</div>';
      ?>

      <div class="row">
        <div class="span1 offset8"><a href="signout.php"><?php echo L('Sign Out') ?></a></div>
      </div>
      <div class="row">
        <img src="../img/cpt-big.png" alt="<?php echo Config::$webPageTitle ?>" />
      </div>
    </div>
  </body>
</html>

