<?php
//vim: ts=2 sw=2

include_once "db.php";
include_once "base_controller.php";

class AccountManagementController extends BaseController {
  protected function signinRequired() {
    return true;
  }

  protected function doAjaxGet() {
    $u = $this->curUser();
    $user_id = null;
    if (isset($_GET['user_id']))
        $user_id = $_GET['user_id'];
    
    $response = array();
    if (!$u->isAccountManagementEnabled())
      $this->renderAjaxError($response, L("Permission denied"));
    
    $model = new User();
    $accounts = $model->accounts($user_id);
    $rows = array();
    foreach($accounts as $account) {
      $parts = array();
      foreach($account as $key => $value) {
          $parts[] = "\"$key\": \"$value\""; 
      }
      $rows[] = "{" . implode(',', $parts) . "}";
    }
    $response = "{\"data\":  [" . implode(',', $rows) . "] }";
    die($response);
  }

  protected function doAjaxPost() {
    $response = array();
    $u = $this->curUser();
    if (!$u->isAccountManagementEnabled())
      $this->renderAjaxError($response, L("Permission denied"));
    $action = $_POST['action'];
    if ($action == 'createAccount') {
      $this->createAccount($response);
    } elseif ($action == 'updateAccount') {
      $this->updateAccount($response);
    } elseif ($action == 'deleteAccount') {
      $this->deleteAccount($response);
    } else {
      $error = sprintf(L("Action %s is not supportted"), $action);
      $this->renderAjaxError($response, $error);
    }
    $this->renderAjaxSuccess($response);
  }
  
  protected function doCreateAccount($u, $name) {
    $password = $_POST['user']['password'];
    $authHash = $_POST['user']['authHash'];
    $token = $_POST['user']['token'];

    $utility_enabled = $_POST['user']['utility_enabled'];
    $system_enabled = $_POST['user']['system_enabled'];
    $account_management_enabled = $_POST['user']['account_management_enabled'];
    $password_change_enabled = $_POST['user']['password_change_enabled'];
    $dashboard_enabled = $_POST['user']['dashboard_enabled'];
    $dashboard_as_landing_page = $_POST['user']['dashboard_as_landing_page'];

    if (isset($password))
      return $u->createAccount($name, $password, $utility_enabled, $system_enabled, $account_management_enabled, $password_change_enabled, $dashboard_enabled, $dashboard_as_landing_page); 
    else {
      if (!isset($authHash) || !isset($token))
        return false;
      return $u->createAccount2($name, $authHash, $token, $utility_enabled, $system_enabled, $account_management_enabled, $password_change_enabled, $dashboard_enabled, $dashboard_as_landing_page);
    }
  }

  protected function createAccount($response) {
    $name = $_POST['user']['name'];
    $u = new User();
    if (!$this->doCreateAccount($u, $name)) {
      $error = sprintf(L("Failed to create account, maybe name '%s' is taken"), $name);
      $this->renderAjaxError($response, $error);
    } else {
      if (!$u->find($name))
        $this->renderAjaxError($response, L("Failed to create account"));

      $response['user_id'] = $u->attr('id');
      $response['name'] = $u->attr('name');
      $this->renderAjaxSuccess($response);
    }
  }
  
  protected function updateAccount($response) {
    if (!$this->curUser()->isAdmin())
      $this->renderAjaxError($response, L("Permission denied"));

    $id = $_GET['user_id'];
    if (!isset($id))
      $this->renderAjaxError($response, L("Invalid parameter"));

    $u = new User();
    if (!$u->findById($id))
      $this->renderAjaxError($response, L("Can not find account"));

    $u->updateAccount($_POST['user']);  
    $response['user_id'] = $id;
    $this->renderAjaxSuccess($response);
  } 

  protected function deleteAccount($response) {
    if (!$this->curUser()->isAdmin())
      $this->renderAjaxError($response, L("Permission denied"));

    $id = $_GET['user_id'];
    if (!isset($id))
      $this->renderAjaxError($response, L("Invalid parameter"));

    $u = new User();
    $u->findById($id);
    $u->deleteAccount();  
    $response['user_id'] = $id;
    $this->renderAjaxSuccess($response);
  } 
}

$controller = new AccountManagementController();
$controller->run();

?>
