(function() {
  var spinner = null;

  jQuery(function() {
    var setMsg = function (msg) {
      var elem = $("#msgDiv");
      if (!msg) {
        elem.hide();
        return;
      }

      elem.html("<h5>"+msg+"</h5>");
      elem.addClass("error");
      elem.show();
    };

    var doSignin = function (e) {
      var elem = $("#signinForm");
      var username = $("#username").val();
      var password = $("#password").val();
      var seed = $("#seed").val();
      var shaObj = new jsSHA(username + password + seed, "TEXT");
      var authHash = shaObj.getHash("SHA-1", "HEX");

      $.ajax({
        type: "POST", 
        data: {authHash: authHash, seed: seed},
        dataType: 'json', 
        beforeSend: function() {
          setMsg();
          if (!spinner)
            spinner = new Spinner();
          spinner.spin(elem[0]);
        },
        success: function(data) {
          if (data.error)
            setMsg(data.error.text);
          else if (data.redirectUrl)
            window.location.href = data.redirectUrl;
        },
        error: function(data, status) {
          setMsg("error: " + status);
        },
        complete: function(data, status) {
          spinner.stop();
        },
      });

      e.preventDefault();
    };

    $("#signinForm form").submit(doSignin);
  });
}).call(this);
