<?php
//vim: ts=2 sw=2

include_once "base_controller.php";

class SigninController extends BaseController {

  protected function isCptDeployed() { 
    $rootPath = $_SERVER['DOCUMENT_ROOT'];
    $cptSigninPath = build_file_path($rootPath, "sdcard", "cpt", "app", "signin.php");
    return file_exists($cptSigninPath);
  }

  public function doGet() {
    if ($this->isSignedin())
      $this->redirect($this->makeUrl("app/utility.php"));
    else {
      if ($this->isCptDeployed())
        $this->redirect($this->makeUrl("/sdcard/cpt/app/signin.php?url_required=/fg_utility_app/app/utility.php"));
    }
  }
  
  public function doAjaxPost() {
    if ($this->isCptDeployed()) {
      $this->redirect($this->makeUrl("/sdcard/cpt/app/signin.php?url_required=/fg_utility_app/app/utility.php"));
      return;
    }

    $authHash = $_POST['authHash'];
    $seed = $_POST['seed'];
    
    $username = "admin";
    $password = "hellocpt";
    
    $response = array();
    if ($authHash != sha1($username . $password . $seed)) {
      $this->renderAjaxError($response, "signin failed");
    }

    $expiry = 0;
    setcookie(session_name(), session_id(), $expiry);

    $_SESSION['user_id'] = 1;
    $_SESSION['user_name'] = 'admin';

    $redirectUrl = $this->makeUrl("app/utility.php");
    if (!empty($_SESSION['url_required']))
    {
      $redirectUrl = $this->makeUrl($_SESSION['url_required']);
      unset($_SESSION['url_required']);
    }
    $response['redirectUrl'] = '/';
    die(<<<EOS
{"redirectUrl": "$redirectUrl" }
EOS
    );
  }
}

$controller = new SigninController();
$controller->run();

?>

<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Signin - Controller Utility</title>

    <link rel="stylesheet" href="../css/pure-min.css">
    <!--[if lte IE 8]>
        <link rel="stylesheet" href="css/grids-responsive-old-ie-min.css">
    <![endif]-->
    <!--[if gt IE 8]><!-->
        <link rel="stylesheet" href="../css/grids-responsive-min.css">
    <!--<![endif]-->

    <link rel="stylesheet" href="../css/signin.css">
</head>

<body>
  <div id="layout" class="pure-g">
    <div id="logo" class="pure-u-1 pure-u-sm-3-5">
      <img src="../img/cpt-big.png" alt="Controler Logo" class="pure-img" />
    </div>

    <div id="signinForm" class="pure-u-1 pure-u-sm-2-5">
      <form class="pure-form pure-form-aligned" method="post" autocomplete="nope">
        <h2 class="form-signin-heading">Please sign in</h2>
        <fieldset>
          <div class="pure-control-group">
            <input name="user[name]" id="username" type="text" placeholder="Username" autofocus>
          </div>
          <div class="pure-control-group">
            <input name="user[password]" id="password" type="password" placeholder="Password" >
            <input type="hidden" id="seed" value="<?php echo randStr() ?>">
          </div>
          <div id="msgDiv" class="pure-control-group" style="display: none;">
          </div>
          <div class="pure-control-group">
            <button name="commit" id="signinBtn" class="pure-button pure-button-primary" type="submit">
              <!-- <i class="fa fa&#45;sign&#45;in"></i> -->
              Sign in
            </button>
          </div>
        </fieldset>
      </form>
    </div>
  </div>
  
  <script type="text/javascript" src="../js/update.min.js"></script>
  <script type="text/javascript" src="../js/jquery-1.10.0.min.js"></script>
  <script type="text/javascript" src="../js/spin.min.js"></script>
  <script type="text/javascript" src="../js/sha1.js"></script>
  <script type="text/javascript" src="../js/signin.js"></script>

</body>
</html>
