<?php

include_once "device_config_file.php";

function randStr($length=16)
{
  return substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, $length);
}

function hashPassword($password, $salt)
{
  return sha1($password . $salt);
}

function arrayMapToString($array, $connector)
{
  $result = array();
  foreach($array as $k => $v) {
    $result[] = "$k='$v'";
  }
  return implode($connector, $result);
}

function startsWith($haystack, $needle) {
    return $needle === "" || strpos($haystack, $needle) === 0;
}

function endsWith($haystack, $needle) {
  return $needle === "" || substr($haystack, -strlen($needle)) === $needle;
}

function cptBaseDir() {
  $curPath = __FILE__;
  $parts = explode(DIRECTORY_SEPARATOR, $curPath);
  array_pop($parts);
  array_pop($parts);
  return implode(DIRECTORY_SEPARATOR, $parts);
}

function sync() {
    // shell_exec("sync");
    // shell_exec("echo 3 > /proc/sys/vm/drop_caches");
    // return;

    $output = array();
    $return_val = 0;
    exec("sync", $output, $return_val);
    error_log("sync output : " . implode("\n", $output) . " return: " . $return_val);

    unset($output);

    $return_val = 0;
    exec("echo 3 > /proc/sys/vm/drop_caches", $output, $return_val);
    error_log("drop caches output : " . implode("\n", $output) . " return: " . $return_val);
}

function build_file_path() {
  return join(DIRECTORY_SEPARATOR, func_get_args($segments));
}

function backupBasePath() {
    $rootPath = $_SERVER['DOCUMENT_ROOT'];
    if (file_exists(build_file_path($rootPath, 'cpt_site_config.php')))
    {
      include_once(build_file_path($rootPath, 'cpt_site_config.php'));
      return CptSiteConfig::$backupBasePath;
    }
    else
      return build_file_path($rootPath, 'sdcard', 'cpt-backups');
}

function sedonaPath() {
    $rootPath = $_SERVER['DOCUMENT_ROOT'];
    if (file_exists(build_file_path($rootPath, 'cpt_site_config.php')))
    {
      include_once(build_file_path($rootPath, 'cpt_site_config.php'));
      return CptSiteConfig::$sedonaPath;
    }
    else
    {
      $sedonaPath = build_file_path('', 'mnt', 'sedona');
      if (!file_exists($sedonaPath))
        $sedonaPath = build_file_path('', 'mnt');

      return $sedonaPath;
    }
}

function rmIfExists($dirPath) {
    if (!is_dir($dirPath))
        return;

    // execCmd('rm -rf ' . $dirPath);
    foreach(new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dirPath, FilesystemIterator::SKIP_DOTS), RecursiveIteratorIterator::CHILD_FIRST) as $path) {
        $path->isFile() ? unlink($path->getPathname()) : rmdir($path->getPathname());
    }
    rmdir($dirPath);
}

function doBackup($name, $cptBasePath=NULL, $backupHistoryDB=false) {
    if (!does_sdcard_exist())
      return "can not make backup when there is no sdcard";

    $backupDir = build_file_path(backupBasePath(), $name);
    if (file_exists($backupDir))
      return "backup folder already exists, please choose a new folder";

    // make sure all things have been saved
    sync();

    if (!mkdir($backupDir, 0777, true))
      return "failed to create backup folder " . $name;

    $sedonaPath = sedonaPath();
    if (!copy(build_file_path($sedonaPath, 'app.sab'),
      build_file_path($backupDir, 'app.sab')))
    {
      rmIfExists($backupDir);
      return "failed to backup app.sab";
    }

    if (!copy(build_file_path($sedonaPath, 'kits.scode'),
      build_file_path($backupDir, 'kits.scode')))
    {
      rmIfExists($backupDir);
      return "failed to backup kits.scode";
    }

    if (empty($cptBasePath))
      $cptBasePath = cptBaseDir();
    $graphicDir = rtrim($cptBasePath, DIRECTORY_SEPARATOR);
    if (is_dir($graphicDir))
    {
      if (!recurseCopy($graphicDir, build_file_path($backupDir, 'cpt')))
      {
        rmIfExists($backupDir);
        return "failed to backup graphics";
      }

      if ($backupHistoryDB)
      {
        $parentPath = dirname($graphicDir);
        $historyDBPath = build_file_path($parentPath, "easyio.db");
        if (file_exists($historyDBPath))
        {
          if (!copy($historyDBPath, build_file_path($backupDir, 'easyio.db')))
            return "failed to backup 'easyio.db'";
        }
        else
            return "can not find history db file 'easyio.db'";
      }
    }

    error_log("backup " . $name . " done");

    sync();
}

function restoreDefaultApp() {
  $defaultDir = '/mnt/default';
  $sedonaPath = sedonaPath();
  if (!copy(build_file_path($defaultDir, 'app.sab'),
    build_file_path($sedonaPath, 'app.sab.writing')))
    return "failed to restore app.sab";
  if (!copy(build_file_path($defaultDir, 'kits.scode'),
    build_file_path($sedonaPath, 'kits.scode.writing')))
    return "failed to restore kits.scode";

  error_log("copied app.sab and kits.scode");

  if (!rename(build_file_path($sedonaPath, 'app.sab.writing'),
    build_file_path($sedonaPath, 'app.sab.stage'))
   || !rename(build_file_path($sedonaPath, 'kits.scode.writing'),
    build_file_path($sedonaPath, 'kits.scode.stage')))
    return "failed to rename 'writing' to 'stage'";

  error_log("restored to default");
  sync();
}

function doRestore($name, $cptBasePath=NULL, $withHistoryDB=true) {
    if (!does_sdcard_exist())
      return "can not restore backup when there is no sdcard";

    $backupDir = build_file_path(backupBasePath(), $name);
    if (!file_exists($backupDir))
      return "backup folder(" . $backupDir . ") does not exist.";

    // make sure all things have been saved
    sync();

    $sedonaPath = sedonaPath();
    if (!copy(build_file_path($backupDir, 'app.sab'),
      build_file_path($sedonaPath, 'app.sab.writing')))
      return "failed to restore app.sab";
    if (!copy(build_file_path($backupDir, 'kits.scode'),
      build_file_path($sedonaPath, 'kits.scode.writing')))
      return "failed to restore kits.scode";

    error_log("copied app.sab and kits.scode");

    if (!rename(build_file_path($sedonaPath, 'app.sab.writing'),
      build_file_path($sedonaPath, 'app.sab.stage'))
     || !rename(build_file_path($sedonaPath, 'kits.scode.writing'),
      build_file_path($sedonaPath, 'kits.scode.stage')))
      return "failed to rename 'writing' to 'stage'";

    if (empty($cptBasePath))
      $cptBasePath = cptBaseDir();
    $graphicDir = rtrim($cptBasePath, DIRECTORY_SEPARATOR);
    $parts = explode(DIRECTORY_SEPARATOR, $graphicDir);
    array_pop($parts);
    $cptParentDir = implode(DIRECTORY_SEPARATOR, $parts);
    $writingPath = build_file_path($cptParentDir, 'cpt-writing');
    rmIfExists($writingPath);
    if (!recurseCopy(build_file_path($backupDir, 'cpt'), $writingPath))
      return "failed to restore graphics, please make sure there is enough free disk space";

    error_log("copied cpt folder");

    rmIfExists(build_file_path($cptParentDir, 'cpt-old'));

    if (is_dir($graphicDir) && !rename($graphicDir, build_file_path($cptParentDir, 'cpt-old')))
      return "failed to rename original cpt to cpt-old";
    if (!rename($writingPath, $graphicDir))
      return "failed to rename cpt.writing to cpt";

    if ($withHistoryDB)
    {
        $historyDBPath = build_file_path($backupDir, 'easyio.db');
        if (file_exists($historyDBPath))
        {
          $origHistoryDBPath = build_file_path($cptParentDir, 'easyio.db');
          if (file_exists($origHistoryDBPath))
            if (!rename($origHistoryDBPath, build_file_path($cptParentDir, 'easyio.db.old')))
              return "failed to rename old history db";

          if (!copy($historyDBPath, $origHistoryDBPath))
            return "failed to restore 'easyio.db'";
        }
    }

    error_log("restored to " . $name);

    sync();

    restartSvm();
}

function doDeleteBackup($name) {
    $backupDir = build_file_path(backupBasePath(), $name);
    if (!file_exists($backupDir))
      return; // just return when backup folder is missing
      // return "backup folder(" . $backupDir . ") does not exist.";

    //security check
    if (!startsWith(realPath($backupDir), backupBasePath()))
      return "invalid backup folder.";

    rmIfExists($backupDir);

    error_log("backup " . $name . " is deleted");

    sync();
}

function doReboot() {
    sync();

    execCmd('reboot');
}

function recurseCopy($src, $dst) {
  $dir = opendir($src);
  mkdir($dst);
  while(false !== ( $file = readdir($dir)) ) {
    if (( $file != '.' ) && ( $file != '..' )) {
      if ( is_dir(build_file_path($src, $file)) ) {
        if (!recurseCopy(build_file_path($src, $file), build_file_path($dst, $file))) {
          closedir($dir);
          return false;
        }
      }
      else {
        if (!copy(build_file_path($src, $file), build_file_path($dst, $file))) {
          closedir($dir);
          return false;
        }
      }
    }
  }
  closedir($dir);
  return true;
}

function execCmd($cmd) {
  exec(escapeshellcmd($cmd));
}

function cleanupGhostScripts() {
    $docRootPath = rtrim($_SERVER['DOCUMENT_ROOT'], DIRECTORY_SEPARATOR);
    $ghostScriptsPath = build_file_path($docRootPath, 'ghost_scripts');

    rmIfExists($ghostScriptsPath);
}

function restartSvm() {
    //reboot command was added since FG+(from cheah)
    //try reboot first, otherwise restart svm in the old way(used by FG)
    if (file_exists("/sbin/reboot"))
        execCmd("/sbin/reboot");
    else
        execCmd("killall FGBase svm.exe");
}

// echo arrayMapToString(array('a' => 1, 'b' =>2, 'c' => 100), ",");

function firmwareUpgradePath() {
    $rootPath = $_SERVER['DOCUMENT_ROOT'];
    if (file_exists(build_file_path($rootPath, 'cpt_site_config.php')))
    {
      include_once(build_file_path($rootPath, 'cpt_site_config.php'));
      return CptSiteConfig::$firmwareUpgradePath;
    }
    else
      return build_file_path('', 'sdcard', 'fg320');
}

function does_sdcard_exist() {
  $filePath = realpath("/sdcard/No SD Card");
  if (file_exists($filePath))
    return false;
  else
    return true;
}

function platformName() {
  //first check /mnt/sedona/easyio.conf file 
  $confFile = new DeviceConfigFile;
  if ($confFile->load()) {
    $name = $confFile->value("Model", NULL);
    if (!is_null($name))
      return strtoupper($name);
  }

  // if can not find easyio.conf, use legacy hacky way
  if (file_exists("/mnt/fw.config"))
    return "FW";

  $matches = array();
  $fg_linux_ver = '2.6.29.2';
  $fs_linux_ver = '3.4';
  $versionStr = file_get_contents("/proc/version"); 
  if (!preg_match('/linux version ([0-9.]+)/i', $versionStr, $matches))
    return "InvalidPlatform";
  else {
    if (count($matches) < 2 || !isset($matches[1]))
      return "InvalidPlatform";
    else {
      $result = strcmp($matches[1], $fg_linux_ver);
      if ($result > 0) {
        $result2 = strcmp($matches[1], $fs_linux_ver);
        if ($result2 >= 0)
          return "FS";
        else
          return "FG+"; # platform released after FG
      }
      else if ($result == 0)
        return "FG"; # FG platform
      else
        return "FG-"; # platform released before FG
    }
  }
}

function file_force_contents($filename, $data, $flags = 0){
  if(!is_dir(dirname($filename)))
      mkdir(dirname($filename).DIRECTORY_SEPARATOR, 0777, true);
  return file_put_contents($filename, $data, $flags);
}

function setupIndex($docRootPath, $cptBasePath, $graphicRoot=true) {
  if (empty($docRootPath))
    $docRootPath = rtrim($_SERVER['DOCUMENT_ROOT'], DIRECTORY_SEPARATOR);
  
  if (empty($cptBasePath))
    $cptBasePath = cptBaseDir();

  $indexPath = join(DIRECTORY_SEPARATOR, array($docRootPath, 'index.html'));
  $indexLegacyPath = join(DIRECTORY_SEPARATOR, array($docRootPath, 'index_legacy.html'));

  if ($graphicRoot) {
    $graphicIndexPath  = join(DIRECTORY_SEPARATOR, array($cptBasePath, 'index.html'));
    if (!file_exists($indexLegacyPath) && file_exists($indexPath))
      copy($indexPath, $indexLegacyPath);
    copy($graphicIndexPath, $indexPath);
  }
  else {
    if (file_exists($indexLegacyPath))
      copy($indexLegacyPath, $indexPath);
  }
}

?>
