<?php
//vim: ts=2 sw=2

class ElapsedTime {
  private $time = null;
  private $last_report_time = null;

  function __construct() {
    $this->time = microtime(true);
    $this->last_report_time = $this->time;
  }

  public function mark() {
    $this->last_report_time = $this->time;
  }

  public function elapsed() {
    $this->time = microtime(true);
    $diff = $this->time - $this->last_report_time;
    $this->mark();
    return $diff;
  }
};

?>
